/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.huggingface.translator.TextEmbeddingBatchTranslator;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import java.io.IOException;
import java.util.Map;

public class TextEmbeddingTranslator
implements Translator<String, float[]> {
    private static final int[] AXIS = new int[]{0};
    private HuggingFaceTokenizer tokenizer;
    private Batchifier batchifier;
    private boolean normalize;
    private String pooling;
    private boolean includeTokenTypes;

    TextEmbeddingTranslator(HuggingFaceTokenizer tokenizer, Batchifier batchifier, String pooling, boolean normalize, boolean includeTokenTypes) {
        this.tokenizer = tokenizer;
        this.batchifier = batchifier;
        this.pooling = pooling;
        this.normalize = normalize;
        this.includeTokenTypes = includeTokenTypes;
    }

    public Batchifier getBatchifier() {
        return this.batchifier;
    }

    public NDList processInput(TranslatorContext ctx, String input) {
        Encoding encoding = this.tokenizer.encode(input);
        ctx.setAttachment("encoding", (Object)encoding);
        return encoding.toNDList(ctx.getNDManager(), this.includeTokenTypes);
    }

    public float[] processOutput(TranslatorContext ctx, NDList list) {
        Encoding encoding = (Encoding)ctx.getAttachment("encoding");
        NDManager manager = ctx.getNDManager();
        NDArray embeddings = TextEmbeddingTranslator.processEmbedding(manager, list, encoding, this.pooling);
        if (this.normalize) {
            embeddings = embeddings.normalize(2.0, 0L);
        }
        return embeddings.toFloatArray();
    }

    public TextEmbeddingBatchTranslator toBatchTranslator(Batchifier batchifier) {
        this.tokenizer.enableBatch();
        return new TextEmbeddingBatchTranslator(this.tokenizer, batchifier, this.pooling, this.normalize, this.includeTokenTypes);
    }

    static NDArray processEmbedding(NDManager manager, NDList list, Encoding encoding, String pooling) {
        NDArray embedding = list.get("last_hidden_state");
        if (embedding == null) {
            embedding = list.head();
        }
        long[] attentionMask = encoding.getAttentionMask();
        NDArray inputAttentionMask = manager.create(attentionMask).toType(DataType.FLOAT32, true);
        switch (pooling) {
            case "mean": {
                return TextEmbeddingTranslator.meanPool(embedding, inputAttentionMask, false);
            }
            case "mean_sqrt_len": {
                return TextEmbeddingTranslator.meanPool(embedding, inputAttentionMask, true);
            }
            case "max": {
                return TextEmbeddingTranslator.maxPool(embedding, inputAttentionMask);
            }
            case "weightedmean": {
                return TextEmbeddingTranslator.weightedMeanPool(embedding, inputAttentionMask);
            }
            case "cls": {
                return embedding.get(new long[]{0L});
            }
        }
        throw new AssertionError((Object)("Unexpected pooling mode: " + pooling));
    }

    private static NDArray meanPool(NDArray embeddings, NDArray attentionMask, boolean sqrt) {
        long[] shape = embeddings.getShape().getShape();
        attentionMask = attentionMask.expandDims(-1).broadcast(shape);
        NDArray inputAttentionMaskSum = attentionMask.sum(AXIS);
        NDArray clamp = inputAttentionMaskSum.clip((Number)Float.valueOf(1.0E-9f), (Number)Float.valueOf(1.0E12f));
        NDArray prod = embeddings.mul(attentionMask);
        NDArray sum = prod.sum(AXIS);
        if (sqrt) {
            return sum.div(clamp.sqrt());
        }
        return sum.div(clamp);
    }

    private static NDArray maxPool(NDArray embeddings, NDArray inputAttentionMask) {
        long[] shape = embeddings.getShape().getShape();
        inputAttentionMask = inputAttentionMask.expandDims(-1).broadcast(shape);
        inputAttentionMask = inputAttentionMask.eq((Number)0);
        embeddings = embeddings.duplicate();
        embeddings.set(inputAttentionMask, (Number)-1.0E9);
        return embeddings.max(AXIS, true);
    }

    private static NDArray weightedMeanPool(NDArray embeddings, NDArray attentionMask) {
        long[] shape = embeddings.getShape().getShape();
        NDArray weight = embeddings.getManager().arange(1.0f, (float)(shape[0] + 1L));
        weight = weight.expandDims(-1).broadcast(shape);
        attentionMask = attentionMask.expandDims(-1).broadcast(shape).mul(weight);
        NDArray maskSum = attentionMask.sum(AXIS);
        NDArray embeddingSum = embeddings.mul(attentionMask).sum(AXIS);
        return embeddingSum.div(maskSum);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer) {
        return new Builder(tokenizer);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer, Map<String, ?> arguments) {
        Builder builder = TextEmbeddingTranslator.builder(tokenizer);
        builder.configure(arguments);
        return builder;
    }

    public static final class Builder {
        private HuggingFaceTokenizer tokenizer;
        private Batchifier batchifier = Batchifier.STACK;
        private boolean normalize = true;
        private String pooling = "mean";
        private boolean includeTokenTypes;

        Builder(HuggingFaceTokenizer tokenizer) {
            this.tokenizer = tokenizer;
        }

        public Builder optBatchifier(Batchifier batchifier) {
            this.batchifier = batchifier;
            return this;
        }

        public Builder optNormalize(boolean normalize) {
            this.normalize = normalize;
            return this;
        }

        public Builder optPoolingMode(String poolingMode) {
            if (!("mean".equals(poolingMode) || "max".equals(poolingMode) || "cls".equals(poolingMode) || "mean_sqrt_len".equals(poolingMode) || "weightedmean".equals(poolingMode))) {
                throw new IllegalArgumentException("Invalid pooling model, must be one of [mean, max, cls, mean_sqrt_len, weightedmean].");
            }
            this.pooling = poolingMode;
            return this;
        }

        public Builder optIncludeTokenTypes(boolean includeTokenTypes) {
            this.includeTokenTypes = includeTokenTypes;
            return this;
        }

        public void configure(Map<String, ?> arguments) {
            String batchifierStr = ArgumentsUtil.stringValue(arguments, (String)"batchifier", (String)"stack");
            this.optBatchifier(Batchifier.fromString((String)batchifierStr));
            this.optNormalize(ArgumentsUtil.booleanValue(arguments, (String)"normalize", (boolean)true));
            this.optPoolingMode(ArgumentsUtil.stringValue(arguments, (String)"pooling", (String)"mean"));
            this.optIncludeTokenTypes(ArgumentsUtil.booleanValue(arguments, (String)"includeTokenTypes"));
        }

        public TextEmbeddingTranslator build() throws IOException {
            return new TextEmbeddingTranslator(this.tokenizer, this.batchifier, this.pooling, this.normalize, this.includeTokenTypes);
        }
    }
}

