/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.huggingface.translator.PretrainedConfig;
import ai.djl.huggingface.translator.TextClassificationTranslator;
import ai.djl.modality.Classifications;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.translate.Batchifier;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;

public class TextClassificationBatchTranslator
implements NoBatchifyTranslator<String[], Classifications[]> {
    private HuggingFaceTokenizer tokenizer;
    private boolean includeTokenTypes;
    private Batchifier batchifier;
    private PretrainedConfig config;

    TextClassificationBatchTranslator(HuggingFaceTokenizer tokenizer, boolean includeTokenTypes, Batchifier batchifier) {
        this.tokenizer = tokenizer;
        this.includeTokenTypes = includeTokenTypes;
        this.batchifier = batchifier;
    }

    public void prepare(TranslatorContext ctx) throws IOException {
        Path path = ctx.getModel().getModelPath();
        Path file = path.resolve("config.json");
        try (BufferedReader reader = Files.newBufferedReader(file);){
            this.config = (PretrainedConfig)JsonUtils.GSON.fromJson((Reader)reader, PretrainedConfig.class);
        }
    }

    public NDList processInput(TranslatorContext ctx, String[] inputs) {
        NDManager manager = ctx.getNDManager();
        Encoding[] encodings = this.tokenizer.batchEncode(inputs);
        NDList[] batch = new NDList[encodings.length];
        for (int i = 0; i < encodings.length; ++i) {
            batch[i] = encodings[i].toNDList(manager, this.includeTokenTypes);
        }
        return this.batchifier.batchify(batch);
    }

    public Classifications[] processOutput(TranslatorContext ctx, NDList list) {
        NDList[] batch = this.batchifier.unbatchify(list);
        Classifications[] ret = new Classifications[batch.length];
        for (int i = 0; i < batch.length; ++i) {
            ret[i] = TextClassificationTranslator.toClassifications(this.config, batch[i]);
        }
        return ret;
    }
}

