/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.huggingface.translator.PretrainedConfig;
import ai.djl.huggingface.translator.TokenClassificationTranslator;
import ai.djl.modality.nlp.translator.NamedEntity;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.translate.Batchifier;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;

public class TokenClassificationBatchTranslator
implements NoBatchifyTranslator<String[], NamedEntity[][]> {
    private HuggingFaceTokenizer tokenizer;
    private Batchifier batchifier;
    private PretrainedConfig config;

    TokenClassificationBatchTranslator(HuggingFaceTokenizer tokenizer, Batchifier batchifier) {
        this.tokenizer = tokenizer;
        this.batchifier = batchifier;
    }

    public void prepare(TranslatorContext ctx) throws IOException {
        Path path = ctx.getModel().getModelPath();
        Path file = path.resolve("config.json");
        try (BufferedReader reader = Files.newBufferedReader(file);){
            this.config = (PretrainedConfig)JsonUtils.GSON.fromJson((Reader)reader, PretrainedConfig.class);
        }
    }

    public NDList processInput(TranslatorContext ctx, String[] inputs) {
        NDManager manager = ctx.getNDManager();
        Encoding[] encodings = this.tokenizer.batchEncode(inputs);
        ctx.setAttachment("encodings", (Object)encodings);
        NDList[] batch = new NDList[encodings.length];
        for (int i = 0; i < encodings.length; ++i) {
            batch[i] = encodings[i].toNDList(manager, false);
        }
        return this.batchifier.batchify(batch);
    }

    public NamedEntity[][] processOutput(TranslatorContext ctx, NDList list) {
        NDList[] batch = this.batchifier.unbatchify(list);
        Encoding[] encodings = (Encoding[])ctx.getAttachment("encodings");
        NamedEntity[][] ret = new NamedEntity[encodings.length][];
        for (int i = 0; i < encodings.length; ++i) {
            ret[i] = TokenClassificationTranslator.toNamedEntities(encodings[i], batch[i], this.config);
        }
        return ret;
    }
}

