/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.huggingface.translator.QuestionAnsweringTranslator;
import ai.djl.modality.nlp.qa.QAInput;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.translate.Batchifier;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.PairList;

public class QuestionAnsweringBatchTranslator
implements NoBatchifyTranslator<QAInput[], String[]> {
    private HuggingFaceTokenizer tokenizer;
    private boolean includeTokenTypes;
    private Batchifier batchifier;

    QuestionAnsweringBatchTranslator(HuggingFaceTokenizer tokenizer, boolean includeTokenTypes, Batchifier batchifier) {
        this.tokenizer = tokenizer;
        this.includeTokenTypes = includeTokenTypes;
        this.batchifier = batchifier;
    }

    public NDList processInput(TranslatorContext ctx, QAInput[] inputs) {
        NDManager manager = ctx.getNDManager();
        PairList pair = new PairList(inputs.length);
        for (QAInput input : inputs) {
            pair.add((Object)input.getQuestion(), (Object)input.getParagraph());
        }
        Encoding[] encodings = this.tokenizer.batchEncode((PairList<String, String>)pair);
        ctx.setAttachment("encodings", (Object)encodings);
        NDList[] batch = new NDList[encodings.length];
        for (int i = 0; i < encodings.length; ++i) {
            batch[i] = encodings[i].toNDList(manager, this.includeTokenTypes);
        }
        return this.batchifier.batchify(batch);
    }

    public String[] processOutput(TranslatorContext ctx, NDList list) {
        NDList[] batch = this.batchifier.unbatchify(list);
        Encoding[] encodings = (Encoding[])ctx.getAttachment("encodings");
        String[] ret = new String[encodings.length];
        for (int i = 0; i < encodings.length; ++i) {
            ret[i] = QuestionAnsweringTranslator.decode(batch[i], encodings[i], this.tokenizer);
        }
        return ret;
    }
}

