/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.zoo;

import ai.djl.Application;
import ai.djl.engine.Engine;
import ai.djl.repository.Repository;
import ai.djl.repository.Version;
import ai.djl.repository.VersionRange;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.util.JsonUtils;
import ai.djl.util.Utils;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HfModelZoo
extends ModelZoo {
    private static final Logger logger = LoggerFactory.getLogger(HfModelZoo.class);
    private static final String REPO = "https://mlrepo.djl.ai/";
    private static final Repository REPOSITORY = Repository.newInstance((String)"Huggingface", (String)"https://mlrepo.djl.ai/");
    private static final String GROUP_ID = "ai.djl.huggingface.pytorch";
    private static final long ONE_DAY = Duration.ofDays(1L).toMillis();

    HfModelZoo() {
        Version version = new Version(Engine.getDjlVersion());
        this.addModels(Application.NLP.FILL_MASK, version);
        this.addModels(Application.NLP.QUESTION_ANSWER, version);
        this.addModels(Application.NLP.TEXT_CLASSIFICATION, version);
        this.addModels(Application.NLP.TEXT_EMBEDDING, version);
        this.addModels(Application.NLP.TOKEN_CLASSIFICATION, version);
    }

    public String getGroupId() {
        return GROUP_ID;
    }

    public Set<String> getSupportedEngines() {
        return Collections.singleton("PyTorch");
    }

    private void addModels(Application app, Version version) {
        Map<String, Map<String, Object>> map = this.listModels(app);
        for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
            VersionRange range;
            String requires;
            Map<String, Object> model = entry.getValue();
            if ("failed".equals(model.get("result")) || (requires = (String)model.get("requires")) != null && !(range = VersionRange.parse((String)requires)).contains(version)) continue;
            String artifactId = entry.getKey();
            this.addModel(REPOSITORY.model(app, GROUP_ID, artifactId, "0.0.1"));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<String, Map<String, Object>> listModels(Application app) {
        try {
            String path = "model/" + app.getPath() + "/ai/djl/huggingface/pytorch/";
            Path dir = Utils.getCacheDir().resolve("cache/repo/" + path);
            if (Files.notExists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            } else if (!Files.isDirectory(dir, new LinkOption[0])) {
                logger.warn("Failed initialize cache directory: " + dir);
                return Collections.emptyMap();
            }
            Type type = new TypeToken<Map<String, Map<String, Object>>>(){}.getType();
            Path file = dir.resolve("models.json");
            if (Files.exists(file, new LinkOption[0])) {
                long lastModified = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
                if (Boolean.getBoolean("offline") || System.currentTimeMillis() - lastModified < ONE_DAY) {
                    try (BufferedReader reader = Files.newBufferedReader(file);){
                        Map map = (Map)JsonUtils.GSON.fromJson((Reader)reader, type);
                        return map;
                    }
                }
            }
            String url = REPO + path + "models.json.gz";
            Path tmp = Files.createTempFile(dir, "models", ".tmp", new FileAttribute[0]);
            try {
                Map map;
                try (GZIPInputStream gis = new GZIPInputStream(new URL(url).openStream());){
                    String json = Utils.toString((InputStream)gis);
                    try (BufferedWriter writer = Files.newBufferedWriter(tmp, new OpenOption[0]);){
                        writer.write(json);
                    }
                    Utils.moveQuietly((Path)tmp, (Path)file);
                    map = (Map)JsonUtils.GSON.fromJson(json, type);
                }
                return map;
            }
            finally {
                Utils.deleteQuietly((Path)tmp);
            }
        }
        catch (IOException e) {
            logger.warn("Failed load index of models: " + app, (Throwable)e);
            return Collections.emptyMap();
        }
    }
}

