/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.huggingface.translator.PretrainedConfig;
import ai.djl.modality.Classifications;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;

public class TextClassificationTranslator
implements Translator<String, Classifications> {
    private HuggingFaceTokenizer tokenizer;
    private Batchifier batchifier;
    private PretrainedConfig config;

    TextClassificationTranslator(HuggingFaceTokenizer tokenizer, Batchifier batchifier) {
        this.tokenizer = tokenizer;
        this.batchifier = batchifier;
    }

    public Batchifier getBatchifier() {
        return this.batchifier;
    }

    public void prepare(TranslatorContext ctx) throws IOException {
        Path path = ctx.getModel().getModelPath();
        Path file = path.resolve("config.json");
        try (BufferedReader reader = Files.newBufferedReader(file);){
            this.config = (PretrainedConfig)JsonUtils.GSON.fromJson((Reader)reader, PretrainedConfig.class);
        }
    }

    public NDList processInput(TranslatorContext ctx, String input) {
        NDManager manager = ctx.getNDManager();
        Encoding encoding = this.tokenizer.encode(input);
        ctx.setAttachment("encoding", (Object)encoding);
        long[] indices = encoding.getIds();
        long[] attentionMask = encoding.getAttentionMask();
        NDList ndList = new NDList(2);
        ndList.add((Object)manager.create(indices));
        ndList.add((Object)manager.create(attentionMask));
        return ndList;
    }

    public Classifications processOutput(TranslatorContext ctx, NDList list) {
        NDArray logits = (NDArray)list.get(0);
        int size = this.config.id2label.size();
        if ("multi_label_classification".equals(this.config.problemType) || size == 1) {
            logits = logits.getNDArrayInternal().sigmoid();
        } else if ("single_label_classification".equals(this.config.problemType) || size > 1) {
            logits = logits.softmax(0);
        }
        long[] indices = logits.argSort(-1, false).toLongArray();
        float[] buf = logits.toFloatArray();
        ArrayList<String> classes = new ArrayList<String>(size);
        ArrayList<Double> probabilities = new ArrayList<Double>(size);
        for (long l : indices) {
            int index = Math.toIntExact(l);
            classes.add(this.config.id2label.get(String.valueOf(index)));
            probabilities.add(Double.valueOf(buf[index]));
        }
        return new Classifications(classes, probabilities);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer) {
        return new Builder(tokenizer);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer, Map<String, ?> arguments) {
        Builder builder = TextClassificationTranslator.builder(tokenizer);
        builder.configure(arguments);
        return builder;
    }

    public static final class Builder {
        private HuggingFaceTokenizer tokenizer;
        private Batchifier batchifier = Batchifier.STACK;

        Builder(HuggingFaceTokenizer tokenizer) {
            this.tokenizer = tokenizer;
        }

        public Builder optBatchifier(Batchifier batchifier) {
            this.batchifier = batchifier;
            return this;
        }

        public void configure(Map<String, ?> arguments) {
            String batchifierStr = ArgumentsUtil.stringValue(arguments, (String)"batchifier", (String)"stack");
            this.optBatchifier(Batchifier.fromString((String)batchifierStr));
        }

        public TextClassificationTranslator build() throws IOException {
            return new TextClassificationTranslator(this.tokenizer, this.batchifier);
        }
    }
}

