/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.modality.nlp.qa.QAInput;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.index.NDIndex;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import java.io.IOException;
import java.util.Map;

public class QuestionAnsweringTranslator
implements Translator<QAInput, String> {
    private HuggingFaceTokenizer tokenizer;
    private boolean includeTokenTypes;
    private Batchifier batchifier;

    QuestionAnsweringTranslator(HuggingFaceTokenizer tokenizer, boolean includeTokenTypes, Batchifier batchifier) {
        this.tokenizer = tokenizer;
        this.includeTokenTypes = includeTokenTypes;
        this.batchifier = batchifier;
    }

    public Batchifier getBatchifier() {
        return this.batchifier;
    }

    public NDList processInput(TranslatorContext ctx, QAInput input) {
        NDManager manager = ctx.getNDManager();
        Encoding encoding = this.tokenizer.encode(input.getQuestion(), input.getParagraph());
        ctx.setAttachment("encoding", (Object)encoding);
        long[] indices = encoding.getIds();
        long[] attentionMask = encoding.getAttentionMask();
        NDList ndList = new NDList(3);
        ndList.add((Object)manager.create(indices));
        ndList.add((Object)manager.create(attentionMask));
        if (this.includeTokenTypes) {
            long[] typeIds = encoding.getTypeIds();
            ndList.add((Object)manager.create(typeIds));
        }
        return ndList;
    }

    public String processOutput(TranslatorContext ctx, NDList list) {
        NDArray startLogits = ((NDArray)list.get(0)).duplicate();
        NDArray endLogits = ((NDArray)list.get(1)).duplicate();
        startLogits.set(new NDIndex(new long[]{0L}), (Number)-100000);
        endLogits.set(new NDIndex(new long[]{0L}), (Number)-100000);
        int startIdx = (int)startLogits.argMax().getLong(new long[0]);
        int endIdx = (int)endLogits.argMax().getLong(new long[0]);
        if (startIdx > endIdx) {
            int tmp = startIdx;
            startIdx = endIdx;
            endIdx = tmp;
        }
        Encoding encoding = (Encoding)ctx.getAttachment("encoding");
        long[] indices = encoding.getIds();
        int len = endIdx - startIdx + 1;
        long[] ids = new long[len];
        System.arraycopy(indices, startIdx, ids, 0, len);
        return this.tokenizer.decode(ids).trim();
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer) {
        return new Builder(tokenizer);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer, Map<String, ?> arguments) {
        Builder builder = QuestionAnsweringTranslator.builder(tokenizer);
        builder.configure(arguments);
        return builder;
    }

    public static final class Builder {
        private HuggingFaceTokenizer tokenizer;
        private boolean includeTokenTypes;
        private Batchifier batchifier = Batchifier.STACK;

        Builder(HuggingFaceTokenizer tokenizer) {
            this.tokenizer = tokenizer;
        }

        public Builder optIncludeTokenTypes(boolean includeTokenTypes) {
            this.includeTokenTypes = includeTokenTypes;
            return this;
        }

        public Builder optBatchifier(Batchifier batchifier) {
            this.batchifier = batchifier;
            return this;
        }

        public void configure(Map<String, ?> arguments) {
            this.optIncludeTokenTypes(ArgumentsUtil.booleanValue(arguments, (String)"includeTokenTypes"));
            String batchifierStr = ArgumentsUtil.stringValue(arguments, (String)"batchifier", (String)"stack");
            this.optBatchifier(Batchifier.fromString((String)batchifierStr));
        }

        public QuestionAnsweringTranslator build() throws IOException {
            return new QuestionAnsweringTranslator(this.tokenizer, this.includeTokenTypes, this.batchifier);
        }
    }
}

