/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.fasttext.engine;

import ai.djl.fasttext.engine.FtModel;
import ai.djl.modality.Classifications;
import ai.djl.ndarray.NDList;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import com.github.jfasttext.FastTextWrapper;
import java.util.ArrayList;

public class TextClassificationTranslator
implements Translator<String, Classifications> {
    private int topK;

    public TextClassificationTranslator() {
        this(1);
    }

    public TextClassificationTranslator(int topK) {
        this.topK = topK;
    }

    public NDList processInput(TranslatorContext ctx, String input) {
        return null;
    }

    public Classifications processOutput(TranslatorContext ctx, NDList list) {
        String input = (String)ctx.getAttachment("input");
        FtModel model = (FtModel)ctx.getModel();
        FastTextWrapper.FloatStringPairVector fspv = model.fta.predictProba(input, this.topK);
        int size = Math.min((int)fspv.size(), this.topK);
        ArrayList<String> classNames = new ArrayList<String>(size);
        ArrayList<Double> probabilities = new ArrayList<Double>(size);
        for (int i = 0; i < size; ++i) {
            probabilities.add(Math.exp(fspv.first((long)i)));
            classNames.add(fspv.second((long)i).getString().substring(9));
        }
        return new Classifications(classNames, probabilities);
    }

    public Batchifier getBatchifier() {
        return null;
    }
}

