/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.fasttext.engine;

import ai.djl.MalformedModelException;
import ai.djl.Model;
import ai.djl.fasttext.engine.FtPredictor;
import ai.djl.fasttext.engine.FtTrainer;
import ai.djl.inference.Predictor;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.Block;
import ai.djl.training.Trainer;
import ai.djl.training.TrainingConfig;
import ai.djl.translate.Translator;
import ai.djl.util.PairList;
import com.github.jfasttext.FastTextWrapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class FtModel
implements Model {
    FastTextWrapper.FastTextApi fta = new FastTextWrapper.FastTextApi();
    private Path modelDir;
    private String modelName;
    private Map<String, String> properties = new ConcurrentHashMap<String, String>();

    FtModel() {
    }

    public void load(Path modelPath, String modelName, Map<String, String> options) throws IOException, MalformedModelException {
        String modelFilePath;
        if (Files.notExists(modelPath, new LinkOption[0])) {
            throw new FileNotFoundException("Model directory doesn't exist: " + modelPath.toAbsolutePath());
        }
        this.modelDir = modelPath.toAbsolutePath();
        this.modelName = modelName;
        Path modelFile = this.modelDir.resolve(modelName);
        if (Files.notExists(modelFile, new LinkOption[0])) {
            if (modelName.endsWith(".ftz") || modelName.endsWith(".bin")) {
                throw new FileNotFoundException("Model file doesn't exist: " + modelFile.toAbsolutePath());
            }
            modelFile = this.modelDir.resolve(modelName + ".ftz");
            if (Files.notExists(modelFile, new LinkOption[0]) && Files.notExists(modelFile = this.modelDir.resolve(modelName + ".ftz"), new LinkOption[0])) {
                throw new FileNotFoundException("Model " + modelName + " not found in directory " + this.modelDir);
            }
        }
        if (!this.fta.checkModel(modelFilePath = modelFile.toString())) {
            throw new MalformedModelException("Malformed FastText model file:" + modelFilePath);
        }
        this.fta.loadModel(modelFilePath);
        this.properties.put("model-type", this.fta.getModelName().getString());
    }

    public void save(Path modelDir, String modelName) {
    }

    public Block getBlock() {
        return null;
    }

    public void setBlock(Block block) {
        throw new UnsupportedOperationException("Fasttext doesn't support Block.");
    }

    public String getName() {
        return this.modelName;
    }

    public Trainer newTrainer(TrainingConfig trainingConfig) {
        return new FtTrainer(this, trainingConfig);
    }

    public <I, O> Predictor<I, O> newPredictor(Translator<I, O> translator) {
        return new FtPredictor<I, O>(this, translator);
    }

    public void setDataType(DataType dataType) {
    }

    public DataType getDataType() {
        return DataType.UNKNOWN;
    }

    public void cast(DataType dataType) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public PairList<String, Shape> describeInput() {
        return null;
    }

    public PairList<String, Shape> describeOutput() {
        return null;
    }

    public String[] getArtifactNames() {
        return null;
    }

    public <T> T getArtifact(String name, Function<InputStream, T> function) {
        return null;
    }

    public URL getArtifact(String artifactName) {
        return null;
    }

    public InputStream getArtifactAsStream(String name) {
        return null;
    }

    public NDManager getNDManager() {
        return null;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    void setModelFile(Path modelFile) {
        this.modelDir = modelFile;
    }

    public void close() {
        this.fta.unloadModel();
        this.fta.close();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("Model (\n\tName: ").append(this.modelName);
        if (this.modelDir != null) {
            sb.append("\n\tModel location: ").append(this.modelDir.toAbsolutePath());
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            sb.append("\n\t").append(entry.getKey()).append(": ").append(entry.getValue());
        }
        sb.append("\n)");
        return sb.toString();
    }
}

