/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.Shape;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.Resource;
import ai.djl.training.dataset.Dataset;
import ai.djl.training.dataset.RandomAccessDataset;
import ai.djl.training.dataset.Record;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.translate.TranslateException;
import ai.djl.util.JsonUtils;
import ai.djl.util.Progress;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BananaDetection
extends RandomAccessDataset {
    private static final String VERSION = "1.0";
    private static final String ARTIFACT_ID = "banana";
    private final Dataset.Usage usage;
    private final Image.Flag flag;
    private final List<Path> imagePaths;
    private final List<float[]> labels;
    private final Resource resource;
    private boolean prepared;

    public BananaDetection(Builder builder) {
        super((RandomAccessDataset.BaseBuilder)builder);
        this.usage = builder.usage;
        this.flag = builder.flag;
        this.imagePaths = new ArrayList<Path>();
        this.labels = new ArrayList<float[]>();
        MRL mrl = MRL.dataset((Application)Application.CV.ANY, (String)builder.groupId, (String)builder.artifactId);
        this.resource = new Resource(builder.repository, mrl, VERSION);
    }

    public static Builder builder() {
        return new Builder();
    }

    protected Record get(NDManager manager, long index) throws IOException {
        int idx = Math.toIntExact(index);
        NDList d = new NDList(new NDArray[]{ImageFactory.getInstance().fromFile(this.imagePaths.get(idx)).toNDArray(manager, this.flag)});
        NDArray label = manager.create(this.labels.get(idx));
        NDList l = new NDList(new NDArray[]{label.reshape(new Shape(new long[]{1L}).addAll(label.getShape()))});
        return new Record(d, l);
    }

    protected long availableSize() {
        return this.imagePaths.size();
    }

    public void prepare(Progress progress) throws IOException, TranslateException {
        Path usagePath;
        if (this.prepared) {
            return;
        }
        Artifact artifact = this.resource.getDefaultArtifact();
        this.resource.prepare(artifact, progress);
        Path root = this.resource.getRepository().getResourceDirectory(artifact);
        switch (this.usage) {
            case TRAIN: {
                usagePath = Paths.get("train", new String[0]);
                break;
            }
            case TEST: {
                usagePath = Paths.get("test", new String[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Validation data not available.");
            }
        }
        usagePath = root.resolve(usagePath);
        Path indexFile = usagePath.resolve("index.file");
        try (BufferedReader reader = Files.newBufferedReader(indexFile);){
            Type mapType = new TypeToken<Map<String, List<Float>>>(){}.getType();
            Map metadata = (Map)JsonUtils.GSON.fromJson((Reader)reader, mapType);
            for (Map.Entry entry : metadata.entrySet()) {
                float[] labelArray = new float[5];
                String imgName = (String)entry.getKey();
                List label = (List)entry.getValue();
                labelArray[0] = ((Float)label.get(0)).floatValue();
                labelArray[1] = ((Float)label.get(1)).floatValue();
                labelArray[2] = ((Float)label.get(2)).floatValue();
                labelArray[3] = ((Float)label.get(3)).floatValue();
                labelArray[4] = ((Float)label.get(4)).floatValue();
                this.imagePaths.add(usagePath.resolve(imgName));
                this.labels.add(labelArray);
            }
        }
        this.prepared = true;
    }

    public static final class Builder
    extends RandomAccessDataset.BaseBuilder<Builder> {
        Repository repository = BasicDatasets.REPOSITORY;
        String groupId = "ai.djl.basicdataset";
        String artifactId = "banana";
        Dataset.Usage usage = Dataset.Usage.TRAIN;
        Image.Flag flag = Image.Flag.COLOR;

        Builder() {
        }

        public Builder self() {
            return this;
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this.self();
        }

        public Builder optRepository(Repository repository) {
            this.repository = repository;
            return this.self();
        }

        public Builder optGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder optArtifactId(String artifactId) {
            if (artifactId.contains(":")) {
                String[] tokens = artifactId.split(":");
                this.groupId = tokens[0];
                this.artifactId = tokens[1];
            } else {
                this.artifactId = artifactId;
            }
            return this;
        }

        public Builder optFlag(Image.Flag flag) {
            this.flag = flag;
            return this.self();
        }

        public BananaDetection build() {
            if (this.pipeline == null) {
                this.pipeline = new Pipeline(new Transform[]{new ToTensor()});
            }
            return new BananaDetection(this);
        }
    }
}

