/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset;

import ai.djl.modality.cv.Rectangle;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.List;

public class CocoMetadata {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(Rectangle.class, (Object)new RectangleDeserializer()).create();
    private List<Image> images;
    private List<Annotation> annotations;
    private List<Category> categories;

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public List<Image> getImages() {
        return this.images;
    }

    public static final class RectangleDeserializer
    implements JsonDeserializer<Rectangle> {
        public Rectangle deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) {
            JsonArray array = json.getAsJsonArray();
            return new Rectangle(array.get(0).getAsDouble(), array.get(1).getAsDouble(), array.get(2).getAsDouble(), array.get(3).getAsDouble());
        }
    }

    public static final class Category {
        private long id;

        public long getId() {
            return this.id;
        }
    }

    public static final class Image {
        private int id;
        @SerializedName(value="coco_url")
        private String cocoUrl;
        private int height;
        private int width;

        public long getId() {
            return this.id;
        }

        public String getCocoUrl() {
            return this.cocoUrl;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }
    }

    public static final class Annotation {
        @SerializedName(value="image_id")
        private long imageId;
        private long id;
        @SerializedName(value="bbox")
        private Rectangle bBox;
        private double area;
        @SerializedName(value="category_id")
        private long categoryId;

        public long getImageId() {
            return this.imageId;
        }

        public long getId() {
            return this.id;
        }

        public Rectangle getBoundingBox() {
            return this.bBox;
        }

        public long getCategoryId() {
            return this.categoryId;
        }

        public double getArea() {
            return this.area;
        }
    }
}

