/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.cv.classification;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.engine.Engine;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.training.dataset.ArrayDataset;
import ai.djl.training.dataset.Dataset;
import ai.djl.training.dataset.RandomAccessDataset;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.util.Progress;
import ai.djl.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public final class Mnist
extends ArrayDataset {
    private static final String ARTIFACT_ID = "mnist";
    private static final String VERSION = "1.0";
    public static final int IMAGE_WIDTH = 28;
    public static final int IMAGE_HEIGHT = 28;
    public static final int NUM_CLASSES = 10;
    private NDManager manager;
    private Dataset.Usage usage;
    private MRL mrl;
    private boolean prepared;

    private Mnist(Builder builder) {
        super((RandomAccessDataset.BaseBuilder)builder);
        this.manager = builder.manager;
        this.manager.setName(ARTIFACT_ID);
        this.usage = builder.usage;
        this.mrl = builder.getMrl();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void prepare(Progress progress) throws IOException {
        Artifact.Item labelItem;
        Artifact.Item imageItem;
        if (this.prepared) {
            return;
        }
        Artifact artifact = this.mrl.getDefaultArtifact();
        this.mrl.prepare(artifact, progress);
        Map map = artifact.getFiles();
        switch (this.usage) {
            case TRAIN: {
                imageItem = (Artifact.Item)map.get("train_data");
                labelItem = (Artifact.Item)map.get("train_labels");
                break;
            }
            case TEST: {
                imageItem = (Artifact.Item)map.get("test_data");
                labelItem = (Artifact.Item)map.get("test_labels");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Validation data not available.");
            }
        }
        this.labels = new NDArray[]{this.readLabel(labelItem)};
        this.data = new NDArray[]{this.readData(imageItem, this.labels[0].size())};
        this.prepared = true;
    }

    private NDArray readData(Artifact.Item item, long length) throws IOException {
        try (InputStream is = this.mrl.getRepository().openStream(item, null);){
            NDArray nDArray;
            block13: {
                if (is.skip(16L) != 16L) {
                    throw new AssertionError((Object)"Failed skip data.");
                }
                byte[] buf = Utils.toByteArray((InputStream)is);
                NDArray array = this.manager.create(new Shape(new long[]{length, 28L, 28L, 1L}), DataType.UINT8);
                try {
                    array.set(buf);
                    nDArray = array.toType(DataType.FLOAT32, false);
                    if (array == null) break block13;
                }
                catch (Throwable throwable) {
                    if (array != null) {
                        try {
                            array.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                array.close();
            }
            return nDArray;
        }
    }

    private NDArray readLabel(Artifact.Item item) throws IOException {
        try (InputStream is = this.mrl.getRepository().openStream(item, null);){
            NDArray nDArray;
            block13: {
                if (is.skip(8L) != 8L) {
                    throw new AssertionError((Object)"Failed skip data.");
                }
                byte[] buf = Utils.toByteArray((InputStream)is);
                NDArray array = this.manager.create(new Shape(new long[]{buf.length}), DataType.UINT8);
                try {
                    array.set(buf);
                    nDArray = array.toType(DataType.FLOAT32, false);
                    if (array == null) break block13;
                }
                catch (Throwable throwable) {
                    if (array != null) {
                        try {
                            array.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                array.close();
            }
            return nDArray;
        }
    }

    public static final class Builder
    extends RandomAccessDataset.BaseBuilder<Builder> {
        private NDManager manager;
        private Repository repository = BasicDatasets.REPOSITORY;
        private String groupId = "ai.djl.basicdataset";
        private String artifactId = "mnist";
        private Dataset.Usage usage = Dataset.Usage.TRAIN;

        Builder() {
            this.pipeline = new Pipeline(new Transform[]{new ToTensor()});
            this.manager = Engine.getInstance().newBaseManager();
        }

        protected Builder self() {
            return this;
        }

        public Builder optManager(NDManager manager) {
            this.manager.close();
            this.manager = manager.newSubManager();
            return this;
        }

        public Builder optRepository(Repository repository) {
            this.repository = repository;
            return this;
        }

        public Builder optGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder optArtifactId(String artifactId) {
            if (artifactId.contains(":")) {
                String[] tokens = artifactId.split(":");
                this.groupId = tokens[0];
                this.artifactId = tokens[1];
            } else {
                this.artifactId = artifactId;
            }
            return this;
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this;
        }

        public Mnist build() {
            return new Mnist(this);
        }

        MRL getMrl() {
            return this.repository.dataset(Application.CV.ANY, this.groupId, this.artifactId, Mnist.VERSION);
        }
    }
}

