/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.Application;
import java.net.URI;

public final class MRL {
    private String type;
    private Application application;
    private String groupId;
    private String artifactId;

    private MRL(String type, Application application, String groupId, String artifactId) {
        this.type = type;
        this.application = application;
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public static MRL model(Application application, String groupId, String artifactId) {
        return new MRL("model", application, groupId, artifactId);
    }

    public static MRL dataset(Application application, String groupId, String artifactId) {
        return new MRL("dataset", application, groupId, artifactId);
    }

    public static MRL undefined(String groupId, String artifactId) {
        return new MRL("", Application.UNDEFINED, groupId, artifactId);
    }

    public URI toURI() {
        StringBuilder sb = new StringBuilder();
        if (!this.type.isEmpty()) {
            sb.append(this.type).append('/');
        }
        sb.append(this.application.getPath()).append('/').append(this.groupId.replace('.', '/')).append('/').append(this.artifactId).append('/');
        return URI.create(sb.toString());
    }

    public Application getApplication() {
        return this.application;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String toString() {
        return this.toURI().toString();
    }
}

