/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.optimizer;

import ai.djl.Device;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.internal.NDArrayEx;
import ai.djl.training.optimizer.Optimizer;
import ai.djl.training.optimizer.learningrate.LearningRateTracker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Nag
extends Optimizer {
    private LearningRateTracker learningRateTracker;
    private float momentum;
    private Map<String, Map<Device, NDArray>> momentumStates;

    protected Nag(Builder builder) {
        super(builder);
        this.learningRateTracker = builder.learningRateTracker;
        this.momentum = builder.momentum;
        this.momentumStates = new ConcurrentHashMap<String, Map<Device, NDArray>>();
    }

    @Override
    public void update(String parameterId, NDArray weight, NDArray grad) {
        float newLearningRate = this.learningRateTracker.getNewLearningRate(this.updateCount(parameterId));
        float weightDecay = this.getWeightDecay();
        NDList inputs = this.momentum != 0.0f ? new NDList(weight, grad, this.withDefaultState(this.momentumStates, parameterId, weight.getDevice(), k -> weight.zerosLike())) : new NDList(weight, grad);
        NDList weights = new NDList(weight);
        NDArrayEx ex = weight.getNDArrayInternal();
        ex.nagUpdate(inputs, weights, newLearningRate, weightDecay, this.rescaleGrad, this.clipGrad, this.momentum);
    }

    public static final class Builder
    extends Optimizer.OptimizerBuilder<Builder> {
        LearningRateTracker learningRateTracker;
        float momentum;

        Builder() {
        }

        public Builder setLearningRateTracker(LearningRateTracker learningRateTracker) {
            this.learningRateTracker = learningRateTracker;
            return this;
        }

        public Builder setMomentum(float momentum) {
            this.momentum = momentum;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Nag build() {
            if (this.learningRateTracker == null) {
                throw new IllegalArgumentException("No lrTracker set");
            }
            if (this.momentum == 0.0f) {
                throw new IllegalArgumentException("The momentum should be set");
            }
            return new Nag(this);
        }
    }
}

