/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class ZipUtils {
    private ZipUtils() {
    }

    public static void unzip(InputStream is, Path dest) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(is);
        while ((entry = zis.getNextEntry()) != null) {
            String name = entry.getName();
            Path file = dest.resolve(name).toAbsolutePath();
            if (entry.isDirectory()) {
                Files.createDirectories(file, new FileAttribute[0]);
                continue;
            }
            Path parentFile = file.getParent();
            if (parentFile == null) {
                throw new AssertionError((Object)("Parent path should never be null: " + file.toString()));
            }
            Files.createDirectories(parentFile, new FileAttribute[0]);
            Files.copy(zis, file, new CopyOption[0]);
        }
    }

    public static void zip(Path src, Path dest) throws IOException {
        File srcFile = src.toFile();
        int prefix = srcFile.getCanonicalPath().length() - srcFile.getName().length();
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(dest, new OpenOption[0]));){
            ZipUtils.addToZip(prefix, srcFile, zos);
        }
    }

    private static void addToZip(int prefix, File file, ZipOutputStream zos) throws IOException {
        String name = file.getCanonicalPath().substring(prefix);
        if (file.isDirectory()) {
            ZipEntry entry = new ZipEntry(name + '/');
            zos.putNextEntry(entry);
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    ZipUtils.addToZip(prefix, f, zos);
                }
            }
        } else if (file.isFile()) {
            ZipEntry entry = new ZipEntry(name);
            zos.putNextEntry(entry);
            Files.copy(file.toPath(), zos);
        }
    }
}

