/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.util;

import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NativeResource<T>
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(NativeResource.class);
    private static final boolean TRACK_RESOURCE = Boolean.getBoolean("ai.djl.track_resource");
    protected final AtomicReference<T> handle;
    private String uid;
    private Exception exception;

    protected NativeResource(T handle) {
        this.handle = new AtomicReference<T>(handle);
        this.uid = handle.toString() + System.nanoTime();
    }

    public boolean isReleased() {
        return this.handle.get() == null;
    }

    public T getHandle() {
        T reference = this.handle.get();
        if (reference == null) {
            if (TRACK_RESOURCE) {
                logger.error("Native resource " + this.uid + " is released. Closed at:", (Throwable)this.exception);
            }
            String message = "Native resource has been released already.";
            throw new IllegalStateException(message);
        }
        return reference;
    }

    public final String getUid() {
        return this.uid;
    }

    public void onClose() {
        if (TRACK_RESOURCE) {
            this.exception = new Exception();
        }
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not implemented.");
    }
}

