/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.nlp.translator;

import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.modality.nlp.qa.QAInput;
import ai.djl.ndarray.BytesSupplier;
import ai.djl.ndarray.NDList;
import ai.djl.translate.Batchifier;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.JsonUtils;
import ai.djl.util.PairList;
import com.google.gson.JsonParseException;

public class QaServingTranslator
implements Translator<Input, Output> {
    private Translator<QAInput, String> translator;

    public QaServingTranslator(Translator<QAInput, String> translator) {
        this.translator = translator;
    }

    @Override
    public Batchifier getBatchifier() {
        return this.translator.getBatchifier();
    }

    @Override
    public void prepare(TranslatorContext ctx) throws Exception {
        this.translator.prepare(ctx);
    }

    @Override
    public NDList processInput(TranslatorContext ctx, Input input) throws Exception {
        QAInput qa;
        PairList<String, BytesSupplier> content = input.getContent();
        if (content.contains("question") && content.contains("paragraph")) {
            String question = input.getAsString("question");
            String paragraph = input.getAsString("paragraph");
            qa = new QAInput(question, paragraph);
        } else {
            BytesSupplier data = input.getData();
            if (data == null) {
                throw new TranslateException("Input data is empty.");
            }
            try {
                qa = (QAInput)JsonUtils.GSON.fromJson(data.getAsString(), QAInput.class);
            }
            catch (JsonParseException e) {
                throw new TranslateException("Input is not a valid json.", e);
            }
        }
        return this.translator.processInput(ctx, qa);
    }

    @Override
    public Output processOutput(TranslatorContext ctx, NDList list) throws Exception {
        String ret = (String)this.translator.processOutput(ctx, list);
        Output output = new Output();
        output.add(ret);
        return output;
    }
}

