/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality;

import ai.djl.ndarray.BytesSupplier;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.util.PairList;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;

public class Input {
    private Map<String, String> properties = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private PairList<String, BytesSupplier> content = new PairList();

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getOrDefault(key, defaultValue);
    }

    public PairList<String, BytesSupplier> getContent() {
        return this.content;
    }

    public void setContent(PairList<String, BytesSupplier> content) {
        this.content = content;
    }

    public void add(byte[] data) {
        this.add(BytesSupplier.wrap(data));
    }

    public void add(String data) {
        this.add(BytesSupplier.wrap(data.getBytes(StandardCharsets.UTF_8)));
    }

    public void add(BytesSupplier data) {
        this.add(null, data);
    }

    public void add(String key, byte[] data) {
        this.add(key, BytesSupplier.wrap(data));
    }

    public void add(String key, String data) {
        this.add(key, BytesSupplier.wrap(data));
    }

    public void add(String key, BytesSupplier data) {
        this.content.add(key, data);
    }

    public void add(int index, String key, BytesSupplier data) {
        this.content.add(index, key, data);
    }

    public BytesSupplier getData() {
        if (this.content.isEmpty()) {
            return null;
        }
        BytesSupplier data = this.get("data");
        if (data == null) {
            return this.get(0);
        }
        return data;
    }

    public NDList getDataAsNDList(NDManager manager) {
        if (this.content.isEmpty()) {
            return null;
        }
        int index = this.content.indexOf("data");
        if (index < 0) {
            index = 0;
        }
        return this.getAsNDList(manager, index);
    }

    public BytesSupplier get(String key) {
        return this.content.get(key);
    }

    public BytesSupplier get(int index) {
        return this.content.valueAt(index);
    }

    public byte[] getAsBytes(String key) {
        BytesSupplier data = this.content.get(key);
        if (data == null) {
            return null;
        }
        return data.getAsBytes();
    }

    public byte[] getAsBytes(int index) {
        return this.content.valueAt(index).getAsBytes();
    }

    public String getAsString(String key) {
        BytesSupplier data = this.content.get(key);
        if (data == null) {
            return null;
        }
        return data.getAsString();
    }

    public String getAsString(int index) {
        return this.content.valueAt(index).getAsString();
    }

    public NDArray getAsNDArray(NDManager manager, String key) {
        int index = this.content.indexOf(key);
        if (index < 0) {
            return null;
        }
        return this.getAsNDArray(manager, index);
    }

    public NDArray getAsNDArray(NDManager manager, int index) {
        BytesSupplier data = this.content.valueAt(index);
        if (data instanceof NDArray) {
            return (NDArray)data;
        }
        return NDArray.decode(manager, data.getAsBytes());
    }

    public NDList getAsNDList(NDManager manager, String key) {
        int index = this.content.indexOf(key);
        if (index < 0) {
            return null;
        }
        return this.getAsNDList(manager, index);
    }

    public NDList getAsNDList(NDManager manager, int index) {
        BytesSupplier data = this.content.valueAt(index);
        if (data instanceof NDList) {
            return (NDList)data;
        }
        if (data instanceof NDArray) {
            return new NDList((NDArray)data);
        }
        return NDList.decode(manager, data.getAsBytes());
    }
}

