/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository.zoo;

import ai.djl.Application;
import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.Model;
import ai.djl.engine.Engine;
import ai.djl.nn.Block;
import ai.djl.nn.BlockFactory;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.Resource;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelLoader;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.DefaultTranslatorFactory;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.ClassLoaderUtils;
import ai.djl.util.Pair;
import ai.djl.util.Progress;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class BaseModelLoader
implements ModelLoader {
    protected ModelZoo modelZoo;
    protected Resource resource;
    protected TranslatorFactory defaultFactory;

    public BaseModelLoader(Repository repository, MRL mrl, String version, ModelZoo modelZoo) {
        this.resource = new Resource(repository, mrl, version);
        this.modelZoo = modelZoo;
        this.defaultFactory = new DefaultTranslatorFactory();
    }

    @Override
    public String getArtifactId() {
        return this.resource.getMrl().getArtifactId();
    }

    @Override
    public Application getApplication() {
        return this.resource.getMrl().getApplication();
    }

    @Override
    public <I, O> ZooModel<I, O> loadModel(Criteria<I, O> criteria) throws IOException, ModelNotFoundException, MalformedModelException {
        Artifact artifact = this.resource.match(criteria.getFilters());
        if (artifact == null) {
            throw new ModelNotFoundException("No matching filter found");
        }
        Progress progress = criteria.getProgress();
        Map<String, Object> arguments = artifact.getArguments(criteria.getArguments());
        Map<String, String> options = artifact.getOptions(criteria.getOptions());
        try {
            String engine;
            TranslatorFactory factory = this.getTranslatorFactory(criteria, arguments);
            Class<I> input = criteria.getInputClass();
            Class<O> output = criteria.getOutputClass();
            if (!(factory != null && factory.isSupported(input, output) || (factory = this.defaultFactory).isSupported(input, output))) {
                throw new ModelNotFoundException(this.getFactoryLookupErrorMessage(factory));
            }
            this.resource.prepare(artifact, progress);
            if (progress != null) {
                progress.reset("Loading", 2L);
                progress.update(1L);
            }
            Path modelPath = this.resource.getRepository().getResourceDirectory(artifact);
            this.loadServingProperties(modelPath, arguments);
            Application application = criteria.getApplication();
            if (application != Application.UNDEFINED) {
                arguments.put("application", application.getPath());
            }
            if ((engine = criteria.getEngine()) == null) {
                engine = (String)arguments.get("engine");
            }
            if (engine == null && this.modelZoo != null) {
                String defaultEngine = Engine.getInstance().getEngineName();
                for (String supportedEngine : this.modelZoo.getSupportedEngines()) {
                    if (supportedEngine.equals(defaultEngine)) {
                        engine = supportedEngine;
                        break;
                    }
                    if (!Engine.hasEngine(supportedEngine)) continue;
                    engine = supportedEngine;
                }
                if (engine == null) {
                    throw new ModelNotFoundException("No supported engine available for model zoo: " + this.modelZoo.getGroupId());
                }
            }
            if (engine != null && !Engine.hasEngine(engine)) {
                throw new ModelNotFoundException(engine + " is not supported");
            }
            String modelName = criteria.getModelName();
            if (modelName == null) {
                modelName = artifact.getName();
            }
            Model model = this.createModel(modelPath, modelName, criteria.getDevice(), criteria.getBlock(), arguments, engine);
            model.load(modelPath, null, options);
            Translator<?, ?> translator = factory.newInstance(input, output, model, arguments);
            ZooModel zooModel = new ZooModel(model, translator);
            return zooModel;
        }
        catch (TranslateException e) {
            throw new ModelNotFoundException("No matching translator found", e);
        }
        finally {
            if (progress != null) {
                progress.end();
            }
        }
    }

    @Override
    public List<Artifact> listModels() throws IOException {
        List<Artifact> list = this.resource.listArtifacts();
        String version = this.resource.getVersion();
        return list.stream().filter(a -> version == null || version.equals(a.getVersion())).collect(Collectors.toList());
    }

    protected Model createModel(Path modelPath, String name, Device device, Block block, Map<String, Object> arguments, String engine) throws IOException {
        String className;
        BlockFactory factory;
        Model model = Model.newInstance(name, device, engine);
        if (block == null && (factory = (BlockFactory)ClassLoaderUtils.findImplementation(modelPath, className = (String)arguments.get("blockFactory"))) != null) {
            block = factory.newBlock(model, modelPath, arguments);
        }
        if (block != null) {
            model.setBlock(block);
        }
        return model;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.resource.getMrl().getGroupId()).append(':').append(this.resource.getMrl().getArtifactId()).append(' ').append(this.getApplication()).append(" [\n");
        try {
            for (Artifact artifact : this.listModels()) {
                sb.append('\t').append(artifact).append('\n');
            }
        }
        catch (IOException e) {
            sb.append("\tFailed load metadata.");
        }
        sb.append(']');
        return sb.toString();
    }

    protected TranslatorFactory getTranslatorFactory(Criteria<?, ?> criteria, Map<String, Object> arguments) {
        TranslatorFactory factory = criteria.getTranslatorFactory();
        if (factory != null) {
            return factory;
        }
        String factoryClass = (String)arguments.get("translatorFactory");
        if (factoryClass != null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            factory = (TranslatorFactory)ClassLoaderUtils.initClass(cl, factoryClass);
        }
        return factory;
    }

    private String getFactoryLookupErrorMessage(TranslatorFactory factory) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("No matching default translator found. The valid input and output classes are: \n");
        for (Pair<Type, Type> io : factory.getSupportedTypes()) {
            sb.append("\t(").append(io.getKey().getTypeName()).append(", ").append(io.getValue().getTypeName()).append(")\n");
        }
        return sb.toString();
    }

    private void loadServingProperties(Path modelDir, Map<String, Object> arguments) throws IOException {
        Path manifestFile = modelDir.resolve("serving.properties");
        if (Files.isRegularFile(manifestFile, new LinkOption[0])) {
            Properties prop = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(manifestFile);){
                prop.load(reader);
            }
            for (String key : prop.stringPropertyNames()) {
                arguments.putIfAbsent(key, prop.getProperty(key));
            }
        }
    }
}

