/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.util;

import ai.djl.util.Progress;

public final class ProgressBar
implements Progress {
    private static final int TOTAL_BAR_LENGTH = 40;
    private String message;
    private String trailingMessage;
    private long max;
    private long progress;
    private int currentPercent;
    private char progressChar = ProgressBar.getProgressChar();

    public ProgressBar() {
        this.max = 1L;
    }

    public ProgressBar(String message, long max) {
        this.reset(message, max);
    }

    public ProgressBar(String message, long max, String trailingMessage) {
        this.reset(message, max);
        this.trailingMessage = trailingMessage;
    }

    @Override
    public final void reset(String message, long max, String trailingMessage) {
        this.message = this.trimMessage(message);
        this.max = max;
        this.trailingMessage = trailingMessage;
        this.currentPercent = 0;
        this.progress = 0L;
    }

    @Override
    public void start(long initialProgress) {
        this.update(initialProgress);
    }

    @Override
    public void end() {
        this.update(this.max - 1L);
    }

    @Override
    public void increment(long increment) {
        this.update(this.progress + increment);
    }

    @Override
    public void update(long progress, String additionalMessage) {
        int i;
        if (Boolean.getBoolean("disableProgressBar") || this.max <= 1L) {
            return;
        }
        this.progress = progress;
        if (additionalMessage == null) {
            additionalMessage = this.trailingMessage;
        }
        int percent = (int)((progress + 1L) * 100L / this.max);
        if ((percent = Math.min(percent, 100)) == this.currentPercent && percent > 0) {
            return;
        }
        this.currentPercent = percent;
        StringBuilder sb = new StringBuilder(100);
        sb.append('\r').append(this.message).append(':');
        for (i = 0; i < 12 - this.message.length(); ++i) {
            sb.append(' ');
        }
        sb.append(String.format("%3d", percent)).append("% |");
        for (i = 0; i < 40; ++i) {
            if (i <= percent * 40 / 100) {
                sb.append(this.progressChar);
                continue;
            }
            sb.append(' ');
        }
        sb.append('|');
        if (additionalMessage != null) {
            sb.append(' ').append(additionalMessage);
        }
        if (percent == 100) {
            System.out.println(sb);
        } else {
            System.out.print(sb);
        }
    }

    private String trimMessage(String message) {
        int len = message.length();
        if (len < 13) {
            return message;
        }
        return message.substring(0, 4) + "..." + message.substring(len - 5);
    }

    private static char getProgressChar() {
        String lang;
        if (System.getProperty("os.name").startsWith("Win")) {
            return '=';
        }
        if (System.getProperty("os.name").startsWith("Linux") && ((lang = System.getenv("LANG")) == null || !lang.contains("UTF-8"))) {
            return '=';
        }
        return '\u2588';
    }
}

