/*
 * Decompiled with CFR 0.152.
 */
package ai.connectif.sdk.data.error;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.HttpException;
import retrofit2.Response;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \t2\u00060\u0001j\u0002`\u0002:\u0001\tB\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lai/connectif/sdk/data/error/ValidationException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "messageErrors", "", "", "(Ljava/util/List;)V", "getMessageErrors", "()Ljava/util/List;", "Companion", "connectif-android-sdk_release"})
public final class ValidationException
extends Exception {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> messageErrors;

    public ValidationException(@NotNull List<String> messageErrors) {
        Intrinsics.checkNotNullParameter(messageErrors, (String)"messageErrors");
        super("HTTP Exception");
        this.messageErrors = messageErrors;
    }

    @NotNull
    public final List<String> getMessageErrors() {
        return this.messageErrors;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\"\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\b2\u0006\u0010\u000b\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lai/connectif/sdk/data/error/ValidationException$Companion;", "", "()V", "fromHttpException", "Lai/connectif/sdk/data/error/ValidationException;", "httpException", "Lretrofit2/HttpException;", "parseErrorBody", "", "", "", "errorBodyString", "connectif-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ValidationException fromHttpException(@NotNull HttpException httpException) {
            ValidationException validationException;
            ResponseBody responseBody;
            Intrinsics.checkNotNullParameter((Object)httpException, (String)"httpException");
            Response response2 = httpException.response();
            Object object = responseBody = response2 != null ? response2.errorBody() : null;
            if (responseBody != null) {
                ValidationException validationException2;
                try {
                    Map<String, List<String>> errorMap = this.parseErrorBody(responseBody.string());
                    List list = errorMap.get("errors");
                    if (list == null) {
                        list = CollectionsKt.listOf((Object)"An error occurred, but could not parse the error details.");
                    }
                    List messageErrors = list;
                    validationException2 = new ValidationException(messageErrors);
                }
                catch (Exception e) {
                    validationException2 = new ValidationException(CollectionsKt.listOf((Object)"An error occurred, but could not parse the error details."));
                }
                validationException = validationException2;
            } else {
                validationException = new ValidationException(CollectionsKt.listOf((Object)"Unknown error occurred, no details provided."));
            }
            return validationException;
        }

        private final Map<String, List<String>> parseErrorBody(String errorBodyString) {
            Gson gson = new Gson();
            Type type2 = new TypeToken<Map<String, ? extends List<? extends String>>>(){}.getType();
            Object object = gson.fromJson(errorBodyString, type2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            return (Map)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

