package ai.connectif.sdk.model

import ai.connectif.sdk.Utils.ensurePositive
import ai.connectif.sdk.Utils.requireValidUrl
import ai.connectif.sdk.Utils.truncate
import ai.connectif.sdk.data.model.event.ProductVisitInternal

data class ProductVisit(val product: Product) {

    internal fun mapToProductVisitEventInternal(): ProductVisitInternal {
        require(this.product.name != "") {
            "name cannot be empty"
        }
        require(this.product.productId != "") {
            "productId cannot be empty"
        }
        require(this.product.productId.length <= 50) {
            "productId cannot have a length greater than 50"
        }
        require(this.product.productDetailUrl != "") {
            "productDetailUrl cannot be empty"
        }
        requireValidUrl(this.product.productDetailUrl, "productDetailUrl")
        requireValidUrl(this.product.imageUrl, "imageUrl")
        requireValidUrl(this.product.thumbnailUrl, "thumbnailUrl")

        val product = this.product.copy(
            name = truncate(this.product.name, 50).toString(),
            description = truncate(this.product.description, 1000),
            categories = truncate(this.product.categories, 20, "categories")?.map {
                truncate(it, 50).toString()
            },
            tags = truncate(this.product.tags, 20, "tags")?.map {
                truncate(it, 50).toString()
            },
            brand = truncate(this.product.brand, 50),
            customField1 = truncate(this.product.customField1, 1000),
            customField2 = truncate(this.product.customField2, 1000),
            customField3 = truncate(this.product.customField3, 1000),
            relatedExternalProductIds = truncate(
                this.product.relatedExternalProductIds,
                20,
                "relatedExternalProductIds"
            ),
            rating = ensurePositive(this.product.rating, "rating"),
            ratingCount = ensurePositive(this.product.ratingCount, "ratingCount"),
            reviewCount = ensurePositive(this.product.reviewCount, "reviewCount"),
            priority = ensurePositive(this.product.priority, "priority")
        )
        return ProductVisitInternal(product)
    }
}
