package ai.connectif.sdk.data.source.model.request

import ai.connectif.sdk.data.model.event.DeviceInfo
import ai.connectif.sdk.data.model.event.ProductBasketItemInternal
import java.math.BigDecimal

internal data class CartRequest(
    override var deviceInfo: DeviceInfo?,
    val cart: CartApiModel,
    override val trackerId: String?,
    override val email: String?
) : EventRequest

internal data class CartApiModel(
    val cartId: String,
    val products: List<ProductBasketItemInternal>,
    val totalQuantity: Int,
    val totalPrice: BigDecimal
)
