package ai.connectif.sdk.data.repository

import ai.connectif.sdk.ConnectifConfig
import ai.connectif.sdk.data.source.LocalPushTokenDataSource
import ai.connectif.sdk.data.source.SettingLocalDataSource
import ai.connectif.sdk.manager.Logger
import java.util.Date
import java.util.UUID
import kotlinx.coroutines.runBlocking

internal class SettingRepositoryImpl(
    private val settingLocalDataSource: SettingLocalDataSource,
    private val pushTokenDataSourceImpl: LocalPushTokenDataSource,
    apiKey: String
) : SettingRepository {

    private val defaultConfig = ConnectifConfig()

    override var config: ConnectifConfig
        get() {
            return ConnectifConfig(
                pushSmallIcon = pushSmallIcon,
                pushChannelId = pushChannelId,
                pushChannelName = pushChannelName,
                webViewMode = webViewMode
            )
        }
        set(value) {
            pushSmallIcon = value.pushSmallIcon
            pushChannelId = value.pushChannelId
            pushChannelName = value.pushChannelName
            webViewMode = value.webViewMode
        }
    override var email: String?
        get() = settingLocalDataSource.email
        set(value) {
            settingLocalDataSource.email = value
        }
    override var pushSmallIcon: Int
        get() = settingLocalDataSource.pushSmallIcon
        set(value) {
            settingLocalDataSource.pushSmallIcon = value
        }

    override var webViewMode: Boolean
        get() = settingLocalDataSource.webViewMode
        set(value) {
            settingLocalDataSource.webViewMode = value
        }

    override var apiKey: String
        get() {
            val apiKey = settingLocalDataSource.apiKey
            if (apiKey != null) {
                return apiKey
            } else {
                throw Exception("apiKey not found")
            }
        }
        set(value) {
            if (value != settingLocalDataSource.apiKey) {
                pushTokenDataSourceImpl.lastUpdate = Date(0)
            }
            settingLocalDataSource.apiKey = value
        }

    override val deviceId: String
        get() {
            val currentDeviceId = settingLocalDataSource.deviceId
            return if (currentDeviceId != null) {
                currentDeviceId
            } else {
                val newDeviceId = UUID.randomUUID().toString()
                settingLocalDataSource.deviceId = newDeviceId
                newDeviceId
            }
        }

    override var trackerId: String?
        get() {
            val value = settingLocalDataSource.trackerId
            return if (value != null || webViewMode) {
                value
            } else {
                runBlocking {
                    val newTrackerId = settingLocalDataSource.getNewTrackerId(apiKey, deviceId)
                    trackerId = newTrackerId
                    newTrackerId
                }
            }
        }
        set(value) {
            val actualTrackerId = settingLocalDataSource.trackerId
            if (actualTrackerId == null) {
                Logger.i(
                    "A new trackerId is set: $value"
                )
            } else if (actualTrackerId != value) {
                Logger.i("trackerId has been changed to : $value")
            }
            settingLocalDataSource.trackerId = value
        }

    override var pushChannelId: String
        get() = settingLocalDataSource.pushChannelId ?: defaultConfig.pushChannelId
        set(value) {
            settingLocalDataSource.pushChannelId = value
        }
    override var pushChannelName: String
        get() = settingLocalDataSource.pushChannelName ?: defaultConfig.pushChannelName
        set(value) {
            settingLocalDataSource.pushChannelName = value
        }

    init {
        this.apiKey = apiKey
    }
}
