package ai.connectif.sdk.data.repository

import ai.connectif.sdk.data.model.event.CartInternal
import ai.connectif.sdk.data.model.event.ContactInfoInternal
import ai.connectif.sdk.data.model.event.CustomInternal
import ai.connectif.sdk.data.model.event.LoginInternal
import ai.connectif.sdk.data.model.event.PageVisitInternal
import ai.connectif.sdk.data.model.event.ProductVisitInternal
import ai.connectif.sdk.data.model.event.PurchaseInternal
import ai.connectif.sdk.data.model.event.RegisterInternal
import ai.connectif.sdk.data.model.event.SearchInternal
import ai.connectif.sdk.data.model.event.SubscribeNewsletterInternal
import ai.connectif.sdk.data.source.EventDataSource
import ai.connectif.sdk.data.source.LocalPushTokenDataSource
import ai.connectif.sdk.data.source.model.response.SendEventResponse

internal class EventRepositoryImpl(
    private val eventDataSource: EventDataSource,
    private val localPushTokenDataSource: LocalPushTokenDataSource
) : EventRepository {
    override suspend fun sendPageVisit(event: PageVisitInternal): SendEventResponse? =
        eventDataSource.sendPageVisit(event)

    override suspend fun sendSearch(event: SearchInternal): SendEventResponse? =
        eventDataSource.sendSearch(event)

    override suspend fun sendProductVisit(event: ProductVisitInternal): SendEventResponse? =
        eventDataSource.sendProductVisit(event)

    override suspend fun sendLogin(event: LoginInternal): SendEventResponse? {
        event.token = localPushTokenDataSource.pushToken
        return eventDataSource.sendLogin(event)
    }

    override suspend fun sendRegister(event: RegisterInternal): SendEventResponse? {
        event.token = localPushTokenDataSource.pushToken
        return eventDataSource.sendRegister(event)
    }

    override suspend fun sendCart(event: CartInternal): SendEventResponse? =
        eventDataSource.sendCart(event)

    override suspend fun sendPurchase(event: PurchaseInternal): SendEventResponse? =
        eventDataSource.sendPurchase(event)

    override suspend fun sendContactInfo(event: ContactInfoInternal): SendEventResponse? =
        eventDataSource.sendContactInfo(event)

    override suspend fun sendCustomEvent(event: CustomInternal): SendEventResponse? =
        eventDataSource.sendCustomEvent(event)

    override suspend fun subscribeToNewsletter(
        event: SubscribeNewsletterInternal
    ): SendEventResponse? = eventDataSource.subscribeToNewsletter(event)
}
