package ai.connectif.sdk.data.model.push

import ai.connectif.sdk.data.ObjectId
import ai.connectif.sdk.data.model.event.DeviceInfo
import ai.connectif.sdk.data.source.model.request.PushClickRequest
import android.os.Parcelable
import kotlinx.parcelize.Parcelize

@Parcelize
internal data class TrackPushClickData(
    var workflowDefinitionId: ObjectId,
    var contentId: ObjectId,
    val sendUuid: String,
    val linkUrl: String? = null,
    val originalLinkUrl: String? = null,
    var trackerId: String? = null,
    var deviceInfo: DeviceInfo? = null
) : Parcelable {
    fun mapToApiModel(): PushClickRequest {
        return PushClickRequest(
            deviceInfo = deviceInfo,
            workflowDefinitionId = workflowDefinitionId,
            contentId = contentId,
            sendUuid = sendUuid,
            linkUrl = linkUrl,
            originalLinkUrl = originalLinkUrl,
            trackerId = trackerId
        )
    }
}
