package ai.connectif.sdk.data.model.event

import ai.connectif.sdk.data.source.model.request.ContactInfoRequest
import java.util.Date

internal data class ContactInfoInternal(
    val name: String?,
    val surname: String?,
    val birthdate: Date?,
    val mobilePhone: String?,
    override var trackerId: String? = null,
    override var email: String? = null,
    override var deviceInfo: DeviceInfo? = null
) : Event

internal fun ContactInfoInternal.mapToApiModel(): ContactInfoRequest = ContactInfoRequest(
    deviceInfo = deviceInfo,
    email = email,
    trackerId = trackerId,
    name = name,
    surname = surname,
    birthdate = birthdate,
    mobilePhone = mobilePhone
)
