/*
 * Decompiled with CFR 0.152.
 */
package ai.connectif.sdk;

import ai.connectif.sdk.manager.Logger;
import android.webkit.URLUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\u0003\u001a\u0004\u0018\u00010\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00072\b\u0010\u0005\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\tJ.\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001a2\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001a2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u001b"}, d2={"Lai/connectif/sdk/Utils;", "", "()V", "ensurePositive", "", "value", "name", "", "(Ljava/lang/Double;Ljava/lang/String;)Ljava/lang/Double;", "", "(Ljava/lang/Integer;Ljava/lang/String;)Ljava/lang/Integer;", "formatApiKeyToHeader", "apiKey", "formatToIso8601Utc", "date", "Ljava/util/Date;", "isValidEmail", "", "email", "isValidPhone", "phone", "requireValidUrl", "", "url", "truncate", "maxLength", "", "connectif-android-sdk_release"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nai/connectif/sdk/Utils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    @Nullable
    public final String formatToIso8601Utc(@Nullable Date date) {
        SimpleDateFormat simpleDateFormat;
        if (date == null) {
            return null;
        }
        SimpleDateFormat $this$formatToIso8601Utc_u24lambda_u240 = simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
        boolean bl = false;
        $this$formatToIso8601Utc_u24lambda_u240.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat dateFormat = simpleDateFormat;
        return dateFormat.format(date);
    }

    @NotNull
    public final String formatApiKeyToHeader(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        return "apiKey " + apiKey;
    }

    public final boolean isValidEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Regex emailRegex = new Regex("^[a-zA-Z0-9.!#$%&\u2019*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\\.[a-zA-Z0-9-]+)+$");
        return email.length() <= 200 && emailRegex.matches((CharSequence)email);
    }

    public final boolean isValidPhone(@NotNull String phone) {
        Intrinsics.checkNotNullParameter((Object)phone, (String)"phone");
        Regex phoneRegex = new Regex("^\\+[1-9]\\d{6,14}$");
        return phoneRegex.matches((CharSequence)phone);
    }

    @Nullable
    public final String truncate(@Nullable String value, int maxLength) {
        String string;
        if (value != null && value.length() > maxLength) {
            Logger.INSTANCE.e('\'' + value + "' exceeds the maximum length " + maxLength + " and has been truncated");
            String string2 = value.substring(0, maxLength);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = value;
        }
        return string;
    }

    @Nullable
    public final List<String> truncate(@Nullable List<String> value, int maxLength, @NotNull String name) {
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value != null && value.size() > maxLength) {
            Logger.INSTANCE.e(name + " exceeds the maximum length " + maxLength + " and has been truncated");
            list = value.subList(0, maxLength);
        } else {
            list = value;
        }
        return list;
    }

    @Nullable
    public final Double ensurePositive(@Nullable Double value, @NotNull String name) {
        Double d;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value != null && value < 0.0) {
            Logger.INSTANCE.e(name + " cannot be a negative number");
            d = null;
        } else {
            d = value;
        }
        return d;
    }

    @Nullable
    public final Integer ensurePositive(@Nullable Integer value, @NotNull String name) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value != null && value < 0) {
            Logger.INSTANCE.e(name + " cannot be a negative number");
            n = null;
        } else {
            n = value;
        }
        return n;
    }

    public final void requireValidUrl(@Nullable String url, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (url != null) {
            if (!(url.length() <= 1000)) {
                boolean $i$a$-require-Utils$requireValidUrl$32 = false;
                String $i$a$-require-Utils$requireValidUrl$32 = name + " cannot have a length greater than 1000";
                throw new IllegalArgumentException($i$a$-require-Utils$requireValidUrl$32.toString());
            }
            if (!URLUtil.isValidUrl((String)url)) {
                boolean bl = false;
                String string = name + " should be a valid absolute URL";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }
}

