/*
 * Decompiled with CFR 0.152.
 */
package ai.connectif.sdk;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004\u00a8\u0006\f"}, d2={"Lai/connectif/sdk/Utils;", "", "()V", "formatApiKeyToHeader", "", "apiKey", "formatToIso8601Utc", "date", "Ljava/util/Date;", "isValidEmail", "", "email", "connectif-android-sdk_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    @Nullable
    public final String formatToIso8601Utc(@Nullable Date date) {
        SimpleDateFormat simpleDateFormat;
        if (date == null) {
            return null;
        }
        SimpleDateFormat $this$formatToIso8601Utc_u24lambda_u240 = simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
        boolean bl = false;
        $this$formatToIso8601Utc_u24lambda_u240.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat dateFormat = simpleDateFormat;
        return dateFormat.format(date);
    }

    @NotNull
    public final String formatApiKeyToHeader(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        return "apiKey " + apiKey;
    }

    public final boolean isValidEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Regex emailRegex = new Regex("^[a-zA-Z0-9.!#$%&\u2019*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\\.[a-zA-Z0-9-]+)+$");
        return emailRegex.matches((CharSequence)email);
    }
}

