/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mma.mobile.tracking.api;

import android.content.Context;
import android.content.SharedPreferences;
import cn.com.mma.mobile.tracking.api.Constant;
import cn.com.mma.mobile.tracking.api.Countly;
import cn.com.mma.mobile.tracking.bean.Argument;
import cn.com.mma.mobile.tracking.bean.Company;
import cn.com.mma.mobile.tracking.bean.SDK;
import cn.com.mma.mobile.tracking.bean.SendEvent;
import cn.com.mma.mobile.tracking.util.CommonUtil;
import cn.com.mma.mobile.tracking.util.DeviceInfoUtil;
import cn.com.mma.mobile.tracking.util.LocationUtil;
import cn.com.mma.mobile.tracking.util.Logger;
import cn.com.mma.mobile.tracking.util.SdkConfigUpdateUtil;
import cn.com.mma.mobile.tracking.util.SharedPreferencedUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RecordEventMessage {
    private Context context;
    private Map<String, String> params;
    private Countly countly;
    private static RecordEventMessage instance;

    private RecordEventMessage(final Context context, Countly countly) {
        this.context = context;
        this.params = DeviceInfoUtil.deviceParams;
        this.countly = countly;
        if (this.params == null || this.params.size() <= 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    RecordEventMessage.this.params = DeviceInfoUtil.fulfillTrackingInfo(context);
                }
            }).start();
        }
    }

    public static synchronized RecordEventMessage getInstance(Context ctx, Countly countly) {
        if (instance == null) {
            instance = new RecordEventMessage(ctx, countly);
        }
        return instance;
    }

    private synchronized void recordEvent(SendEvent sendEvent) {
        this.params.put("LBS", LocationUtil.getInstance(this.context).getLocation());
        StringBuilder builder = new StringBuilder();
        String hostUrl = CommonUtil.getHostURL(sendEvent.getUrl());
        SDK sdk = SdkConfigUpdateUtil.getSdk(this.context);
        if (sdk != null && sdk.companies != null) {
            for (Company company : sdk.companies) {
                if (hostUrl.endsWith(company.domain.url)) {
                    ArrayList<String> requiredArgmentValue = new ArrayList<String>();
                    String separator = "";
                    String equalizer = "";
                    String redirectURLValue = "";
                    for (Argument argument : company.config.arguments) {
                        if (!argument.isRequired) continue;
                        separator = company.separator;
                        equalizer = company.equalizer;
                        requiredArgmentValue.add(argument.value);
                    }
                    Map removedExistArgmentAndGetRedirectURL = CommonUtil.removeExistArgmentAndGetRedirectURL(sendEvent.getUrl(), requiredArgmentValue, separator, equalizer, redirectURLValue);
                    String url = (String)removedExistArgmentAndGetRedirectURL.get("URL");
                    builder.append(url);
                    String valueAndRedirectURL = "";
                    for (Argument argument : company.config.arguments) {
                        if (!argument.isRequired) continue;
                        if ("TS".equals(argument.key)) {
                            builder.append(String.valueOf(company.separator) + argument.value + (company.equalizer != null ? company.equalizer : "") + (company.timeStampUseSecond ? sendEvent.getTimestamp() / 1000L : sendEvent.getTimestamp()));
                            continue;
                        }
                        if ("MUDS".equals(argument.key)) {
                            builder.append(String.valueOf(company.separator) + argument.value + (company.equalizer != null ? company.equalizer : "") + CommonUtil.encodingUTF8(sendEvent.muds, argument, company));
                            continue;
                        }
                        if ("REDIRECTURL".equals(argument.key)) {
                            String patternString = String.valueOf(company.separator) + argument.value + ".*";
                            Pattern pattern = Pattern.compile(patternString);
                            Matcher matcher = pattern.matcher(sendEvent.getUrl());
                            if (!matcher.find()) continue;
                            Constant.REDIRECTURL_VALUE = matcher.group(0);
                            Logger.d("mma_redirect_url :" + Constant.REDIRECTURL_VALUE);
                            continue;
                        }
                        if ("AAID".equals(argument.key)) {
                            builder.append(String.valueOf(company.separator) + argument.value + (company.equalizer != null ? company.equalizer : "") + CommonUtil.md5(this.params.get(argument.key)));
                            continue;
                        }
                        builder.append(String.valueOf(company.separator) + argument.value + (company.equalizer != null ? company.equalizer : "") + CommonUtil.encodingUTF8(this.params.get(argument.key), argument, company));
                    }
                    ArrayList<String> requiredEventValue = new ArrayList<String>();
                    builder = new StringBuilder(CommonUtil.removeExistEvent(builder.toString(), requiredEventValue, separator, equalizer));
                    builder.append(valueAndRedirectURL);
                    if (company.signature != null && company.signature.paramKey != null) {
                        String signatureString = CommonUtil.getSignature(this.context, builder.toString());
                        builder.append(String.valueOf(company.separator) + company.signature.paramKey + (company.equalizer != null ? company.equalizer : "") + CommonUtil.encodingUTF8(signatureString));
                    }
                    builder.append(Constant.REDIRECTURL_VALUE);
                    String resultUrl = builder.toString();
                    long longValue = this.getExpirationTime(company, company.timeStampUseSecond ? sendEvent.getTimestamp() / 1000L : sendEvent.getTimestamp());
                    SharedPreferencedUtil.putLong(this.context, "cn.com.mma.mobile.tracking.normal", resultUrl, longValue);
                    continue;
                }
                Logger.d("domain\u4e0d\u5339\u914d" + hostUrl + " company.domain.url:" + company.domain.url);
            }
        }
    }

    public void recordEventWithUrl(String url) {
        SendEvent sendEvent = new SendEvent();
        sendEvent.setTimestamp(System.currentTimeMillis());
        url = url.replaceAll(" ", "");
        sendEvent.setUrl(url);
        this.recordEvent(sendEvent);
        SharedPreferences sharedPreferences = SharedPreferencedUtil.getSharedPreferences(this.context, "cn.com.mma.mobile.tracking.normal");
        if (sharedPreferences.getAll().keySet().size() >= Constant.OFFLINECACHE_LENGTH) {
            this.countly.startNormalRun();
        }
    }

    private long getExpirationTime(Company company, Long timeStamp) {
        long result;
        block8: {
            result = 0L;
            if (company != null) {
                if (company.sswitch.offlineCacheExpiration != null) {
                    try {
                        if (company.timeStampUseSecond) {
                            result = Long.parseLong(company.sswitch.offlineCacheExpiration.trim()) * 1000L + timeStamp * 1000L;
                            break block8;
                        }
                        result = Long.parseLong(company.sswitch.offlineCacheExpiration.trim()) * 1000L + timeStamp;
                    }
                    catch (Exception e) {
                        if (company != null) {
                            result = company.timeStampUseSecond ? 86400000L + timeStamp * 1000L : 86400000L + timeStamp;
                            break block8;
                        }
                        result = 86400000L + timeStamp;
                    }
                } else {
                    result = company != null ? (company.timeStampUseSecond ? 86400000L + timeStamp * 1000L : 86400000L + timeStamp) : 86400000L + timeStamp;
                }
            } else {
                result = company != null ? (company.timeStampUseSecond ? 86400000L + timeStamp * 1000L : 86400000L + timeStamp) : 86400000L + timeStamp;
            }
        }
        return result;
    }
}

