/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mma.mobile.tracking.api;

import android.content.Context;
import android.content.SharedPreferences;
import cn.com.mma.mobile.tracking.api.Constant;
import cn.com.mma.mobile.tracking.api.RecordEventMessage;
import cn.com.mma.mobile.tracking.api.SendMessageThread;
import cn.com.mma.mobile.tracking.bean.SDK;
import cn.com.mma.mobile.tracking.util.DeviceInfoUtil;
import cn.com.mma.mobile.tracking.util.LocationUtil;
import cn.com.mma.mobile.tracking.util.Logger;
import cn.com.mma.mobile.tracking.util.SdkConfigUpdateUtil;
import cn.com.mma.mobile.tracking.util.SharedPreferencedUtil;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;

public class Countly {
    private static Countly instance = null;
    private RecordEventMessage recordEventMessage;
    protected SendMessageThread sendNormalMessageThread;
    protected SendMessageThread sendFailedMessageThread;
    private Context ctx;
    private long timer_delay = 0L;
    private static Timer normalTimer;
    private static Timer failedTimer;
    private static HashSet<String> requestList;

    public HashSet<String> getHashSet() {
        return requestList;
    }

    public static synchronized Countly sharedInstance() {
        if (instance == null) {
            instance = new Countly();
            requestList = new HashSet();
        }
        return instance;
    }

    public void setLogState(boolean isPrintOut) {
        Logger.DEBUG_LOG = isPrintOut;
    }

    public void init(Context context, String configUrl) {
        this.recordEventMessage = RecordEventMessage.getInstance(context, this);
        Countly.instance.ctx = context;
        normalTimer = new Timer();
        failedTimer = new Timer();
        SdkConfigUpdateUtil.initSdkConfigResult(context, configUrl);
        this.initDeviceInfo(context);
        SDK sdk = SdkConfigUpdateUtil.getSdk(context);
        if (sdk == null) {
            this.timer_delay = 3600000L;
        }
        instance.startTask(sdk);
    }

    private void initDeviceInfo(final Context context) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                DeviceInfoUtil.fulfillTrackingInfo(context);
            }
        }).start();
    }

    private void startTask(SDK sdk) {
        try {
            normalTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Countly.this.startNormalRun();
                }
            }, 0L, sdk == null ? this.timer_delay : (long)(Constant.OFFLINECACHE_QUEUEEXPIRATIONSECS * 1000));
            failedTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Countly.this.startFailedRun();
                }
            }, 0L, sdk == null ? this.timer_delay : (long)(Constant.OFFLINECACHE_QUEUEEXPIRATIONSECS * 1000));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startNormalRun() {
        if (this.sendNormalMessageThread != null && (this.sendNormalMessageThread.getState() == Thread.State.NEW || this.sendNormalMessageThread.isAlive())) {
            System.out.println("--------------normal\u6b63\u5728\u53d1\u9001\uff0c\u6682\u672a\u505c");
            return;
        }
        SharedPreferences sp = SharedPreferencedUtil.getSharedPreferences(this.ctx, "cn.com.mma.mobile.tracking.normal");
        if (sp == null || sp.getAll().isEmpty()) {
            return;
        }
        this.sendNormalMessageThread = new SendMessageThread("cn.com.mma.mobile.tracking.normal", this.ctx, true);
        this.sendNormalMessageThread.start();
    }

    private void startFailedRun() {
        if (this.sendFailedMessageThread != null && (this.sendFailedMessageThread.getState() == Thread.State.NEW || this.sendFailedMessageThread.isAlive())) {
            System.out.println("--------------failed\u6b63\u5728\u53d1\u9001\uff0c\u6682\u672a\u505c");
            return;
        }
        SharedPreferences sp = SharedPreferencedUtil.getSharedPreferences(this.ctx, "cn.com.mma.mobile.tracking.falied");
        if (sp == null || sp.getAll().isEmpty()) {
            return;
        }
        this.sendFailedMessageThread = new SendMessageThread("cn.com.mma.mobile.tracking.falied", this.ctx, false);
        this.sendFailedMessageThread.start();
    }

    public void onClick(String url) {
        try {
            if (this.recordEventMessage != null) {
                this.recordEventMessage.recordEventWithUrl(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onExpose(String url) {
        try {
            if (this.recordEventMessage != null) {
                this.recordEventMessage.recordEventWithUrl(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stopLoopTimer() {
        try {
            if (normalTimer != null) {
                normalTimer.cancel();
                normalTimer.purge();
                normalTimer = null;
            }
            if (failedTimer == null) {
                return;
            }
            failedTimer.cancel();
            failedTimer.purge();
            failedTimer = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void terminateSDK() {
        try {
            this.stopLoopTimer();
            this.recordEventMessage = null;
            if (this.sendNormalMessageThread != null) {
                this.sendNormalMessageThread = null;
            }
            if (this.sendFailedMessageThread != null) {
                this.sendFailedMessageThread = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        instance = null;
    }

    public void stopListenerLocation(Context context) {
        try {
            LocationUtil.getInstance(context).stopListenLocation();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

