/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.util;

import ai.botbrain.ttcloud.api.TtCloudManager;
import ai.botbrain.ttcloud.sdk.model.RecommendEntity;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.util.LogUtil;
import android.app.Application;
import android.content.Context;
import com.firedata.sdk.Firedata;
import com.firedata.sdk.Props;
import com.firedata.sdk.Tracker;
import com.qq.e.ads.nativ.NativeMediaADData;

public class FireDataManager {
    private static final String TAG = FireDataManager.class.getSimpleName();
    private static String mAppId;

    public static void init(Application application, String appId, String appKey) {
        mAppId = appId;
        Firedata.init((Context)application, (String)"FDU5D2P34", (String)appKey);
        Firedata.setDebug((boolean)TtCloudManager.DEBUG);
        Firedata.enableCrashReporting();
        Firedata.enableForegroundTracking((Application)application);
    }

    public static String getGuid() {
        String guid = "";
        try {
            guid = Tracker.getInstance().getGuidSync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LogUtil.i(TAG, "guid" + guid);
        if (null == guid || guid.equals("")) {
            return "1";
        }
        return guid;
    }

    public static void clickMore() {
        try {
            Props props = new Props();
            props.event("sid", (Object)TtCloudManager.getSid()).event("app_name", (Object)mAppId).event("uid", (Object)Firedata.getGuid());
            Firedata.event((String)"recommend", (String)"more", (Props)props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void qqAdClick(NativeMediaADData ad) {
        try {
            Props props = new Props();
            props.event("des", (Object)ad.getDesc()).event("sid", (Object)TtCloudManager.getSid()).event("title", (Object)ad.getTitle()).event("app_name", (Object)mAppId).event("imgUrl", (Object)ad.getImgUrl());
            Firedata.event((String)"recommend", (String)"ad_click", (Props)props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void botAdClick(RecommendEntity.Data2 data1) {
        try {
            Props props = new Props();
            props.event("des", (Object)data1.des).event("sid", (Object)TtCloudManager.getSid()).event("title", (Object)data1.title).event("app_name", (Object)mAppId).event("pic_url", (Object)data1.pic_url);
            Firedata.event((String)"recommend", (String)"ad_click", (Props)props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void qqAdShow(NativeMediaADData adData) {
        try {
            Props props = new Props();
            props.event("des", (Object)adData.getDesc()).event("sid", (Object)TtCloudManager.getSid()).event("title", (Object)adData.getTitle()).event("app_name", (Object)mAppId).event("imgUrl", (Object)adData.getImgUrl());
            Firedata.event((String)"recommend", (String)"ad_show", (Props)props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void botAdShow(RecommendEntity.Data data) {
        try {
            RecommendEntity.Data2 data2 = data.data;
            Props props = new Props();
            props.event("des", (Object)data2.des).event("title", (Object)data2.title).event("type", (Object)data2.type).event("app_name", (Object)mAppId).event("sid", (Object)TtCloudManager.getSid());
            Firedata.event((String)"recommend", (String)"ad_show", (Props)props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sec_cat_click(TopTitleEntity.SubColumns labelData) {
        try {
            Props props = new Props();
            props.event("sid", (Object)TtCloudManager.getSid()).event("uid", (Object)FireDataManager.getGuid()).event("app_name", (Object)mAppId);
            Firedata.event((String)labelData.name, (String)"sec_cat_click", (Props)props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void refresh(String category) {
        try {
            Props props = new Props();
            props.event("sid", (Object)TtCloudManager.getSid()).event("app_name", (Object)mAppId);
            Firedata.event((String)category, (String)"refresh", (Props)props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadMore(String category) {
        try {
            Props props = new Props();
            props.event("sid", (Object)TtCloudManager.getSid()).event("app_name", (Object)mAppId);
            Firedata.event((String)category, (String)"load_more", (Props)props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void clickContent(String category, String name, String iid) {
        try {
            Props props = new Props();
            props.event("sid", (Object)TtCloudManager.getSid()).event("type", (Object)"movie").event("name", (Object)name).event("app_name", (Object)mAppId).event("iid", (Object)iid);
            Firedata.event((String)category, (String)"c_click", (Props)props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void clickCsn(String category, String name, String iid, String csn) {
        try {
            Props props = new Props();
            props.event("sid", (Object)TtCloudManager.getSid()).event("name", (Object)name).event("csn", (Object)csn).event("app_name", (Object)mAppId).event("iid", (Object)iid);
            Firedata.event((String)category, (String)"select_csn", (Props)props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void play(String category) {
        try {
            Props props = new Props();
            props.event("sid", (Object)TtCloudManager.getSid()).event("app_name", (Object)mAppId);
            Firedata.event((String)category, (String)"play", (Props)props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

