/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.activity;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.adapter.RecommendHomeAdapter;
import ai.botbrain.ttcloud.sdk.model.RecommendEntity;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.presenter.AdManager;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.KeyBoardUtil;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import cn.bingoogolapple.refreshlayout.BGANormalRefreshViewHolder;
import cn.bingoogolapple.refreshlayout.BGARefreshLayout;
import cn.bingoogolapple.refreshlayout.BGARefreshViewHolder;
import com.firedata.sdk.Firedata;
import com.lzy.okgo.callback.StringCallback;
import com.lzy.okgo.model.Response;
import java.util.ArrayList;
import java.util.List;

public class TsdSearchActivity
extends Activity
implements BGARefreshLayout.BGARefreshLayoutDelegate {
    private SearchObserver searchObserver;
    private RecommendHomeAdapter recommendHomeAdapter;
    private boolean PULL_TO_REFRESH = true;
    private int pageCurrent = 0;
    private String searchString;
    private List<RecommendEntity.Data> datas;
    private ImageView iv_clear_img;
    private EditText et_chat_title_search;
    BGARefreshLayout mRefreshLayout;
    private TextWatcher mTextWatcher = new TextWatcher(){

        public void afterTextChanged(Editable s) {
            TsdSearchActivity.this.searchString = TsdSearchActivity.this.et_chat_title_search.getText().toString();
            if (!TextUtils.isEmpty((CharSequence)TsdSearchActivity.this.searchString) && TsdSearchActivity.this.searchString.length() > 0) {
                TsdSearchActivity.this.iv_clear_img.setVisibility(0);
            } else {
                TsdSearchActivity.this.iv_clear_img.setVisibility(8);
            }
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.tsd_bbn_activity_search);
        this.datas = new ArrayList<RecommendEntity.Data>();
        this.recommendHomeAdapter = new RecommendHomeAdapter((Context)this, this.datas, null);
        this.searchObserver = new SearchObserver();
        Firedata.pageViewStart((String)"SearchActivity");
        this.initView();
    }

    private void initRefreshLayout() {
        this.mRefreshLayout = (BGARefreshLayout)this.findViewById(R.id.rl_modulename_refresh);
        this.mRefreshLayout.setDelegate((BGARefreshLayout.BGARefreshLayoutDelegate)this);
        this.mRefreshLayout.setPullDownRefreshEnable(false);
        this.mRefreshLayout.setRefreshScaleDelegate(new BGARefreshLayout.BGARefreshScaleDelegate(){

            public void onRefreshScaleChanged(float scale, int moveYDistance) {
            }
        });
        BGANormalRefreshViewHolder refreshViewHolder = new BGANormalRefreshViewHolder((Context)this, true);
        refreshViewHolder.setPullDownRefreshText("\u4e0b\u62c9\u63a8\u8350");
        refreshViewHolder.setRefreshingText("\u52aa\u529b\u63a8\u8350\u4e2d");
        refreshViewHolder.setReleaseRefreshText("\u91ca\u653e\u63a8\u8350");
        refreshViewHolder.setLoadingMoreText("\u52aa\u529b\u63a8\u8350\u4e2d");
        this.mRefreshLayout.setRefreshViewHolder((BGARefreshViewHolder)refreshViewHolder);
    }

    protected void onDestroy() {
        super.onDestroy();
        Firedata.pageViewEnd((String)"SearchActivity");
    }

    public void backClick(View view) {
        this.finish();
    }

    private void initView() {
        this.initRefreshLayout();
        this.iv_clear_img = (ImageView)this.findViewById(R.id.bbn_iv_clear_img);
        this.et_chat_title_search = (EditText)this.findViewById(R.id.et_chat_title_search);
        this.et_chat_title_search.addTextChangedListener(this.mTextWatcher);
        this.iv_clear_img.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TsdSearchActivity.this.et_chat_title_search.setText((CharSequence)"");
            }
        });
        this.et_chat_title_search.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                boolean handled = false;
                if (actionId == 3) {
                    handled = true;
                    KeyBoardUtil.hide(TsdSearchActivity.this);
                    TsdSearchActivity.this.pageCurrent = 0;
                    TsdSearchActivity.this.PULL_TO_REFRESH = true;
                    RestApiImpl.searchVideo(TsdSearchActivity.this.searchObserver, TsdSearchActivity.this.searchString, String.valueOf(TsdSearchActivity.this.pageCurrent));
                }
                return handled;
            }
        });
        this.findViewById(R.id.ib_search).setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                KeyBoardUtil.hide(TsdSearchActivity.this);
                TsdSearchActivity.this.pageCurrent = 0;
                TsdSearchActivity.this.PULL_TO_REFRESH = true;
                RestApiImpl.searchVideo(TsdSearchActivity.this.searchObserver, TsdSearchActivity.this.searchString, String.valueOf(TsdSearchActivity.this.pageCurrent));
            }
        });
        ListView mListView = (ListView)this.findViewById(R.id.load_more_small_image_list_view);
        mListView.setAdapter((ListAdapter)this.recommendHomeAdapter);
    }

    public synchronized void renderFeedList(boolean PULL_TO_REFRESH, String response) {
        this.mRefreshLayout.endLoadingMore();
        try {
            response = response.equals("") ? "error" : response;
            RecommendEntity recommendEntity = GsonUtil.GsonToBean(response, RecommendEntity.class);
            if (PULL_TO_REFRESH) {
                this.datas.clear();
            }
            this.datas.addAll(recommendEntity.data);
            AdManager.init(this.datas);
            SparseArray<String> count = AdManager.getAdSlots();
            this.recommendHomeAdapter.notifyDataSetChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onBGARefreshLayoutBeginRefreshing(BGARefreshLayout refreshLayout) {
    }

    public boolean onBGARefreshLayoutBeginLoadingMore(BGARefreshLayout refreshLayout) {
        this.PULL_TO_REFRESH = false;
        this.pageCurrent += 10;
        RestApiImpl.searchVideo(this.searchObserver, this.searchString, String.valueOf(this.pageCurrent));
        return true;
    }

    private final class SearchObserver
    extends StringCallback {
        private SearchObserver() {
        }

        public void onError(Response<String> response) {
            super.onError(response);
            TsdSearchActivity.this.mRefreshLayout.endLoadingMore();
        }

        public void onSuccess(Response<String> response) {
            String s = (String)response.body();
            TsdSearchActivity.this.renderFeedList(TsdSearchActivity.this.PULL_TO_REFRESH, s);
        }
    }
}

