/*
 * Decompiled with CFR 0.152.
 */
package com.firedata.sdk;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.os.Handler;
import com.firedata.sdk.Tracker;
import com.firedata.sdk.tools.Logy;

@TargetApi(value=14)
class FiredataCallbacks
implements Application.ActivityLifecycleCallbacks {
    public static final String TAG = "com.firedata.Callbacks";
    private static final String NULLMSG = "Need to initialize with Tracker instance";
    private Tracker tracker = null;
    private Handler mHandler = new Handler();
    private Runnable check;
    private boolean mIsForeground = false;
    private boolean mPaused = true;
    public static final int CHECK_DELAY = 500;

    public FiredataCallbacks(Tracker tracker) {
        if (tracker == null) {
            Logy.e(TAG, NULLMSG);
            return;
        }
        this.tracker = tracker;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
        if (this.tracker == null) {
            Logy.e(TAG, NULLMSG);
            return;
        }
        this.mPaused = true;
        if (this.check != null) {
            this.mHandler.removeCallbacks(this.check);
        }
        this.check = new Runnable(){

            @Override
            public void run() {
                if (FiredataCallbacks.this.mIsForeground && FiredataCallbacks.this.mPaused) {
                    FiredataCallbacks.this.mIsForeground = false;
                    FiredataCallbacks.this.tracker.background();
                }
            }
        };
        this.mHandler.postDelayed(this.check, 500L);
        this.tracker.onExitForeground(this.getCurrentTimeMillis());
    }

    public void onActivityResumed(Activity activity) {
        if (this.tracker == null) {
            Logy.e(TAG, NULLMSG);
            return;
        }
        this.mPaused = true;
        boolean wasBackground = !this.mIsForeground;
        this.mIsForeground = true;
        if (this.check != null) {
            this.mHandler.removeCallbacks(this.check);
        }
        if (wasBackground) {
            this.tracker.foreground();
        }
        this.tracker.onEnterForeground(this.getCurrentTimeMillis());
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outstate) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }
}

