/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.widget;

import ai.botbrain.ttcloud.api.TtCloudManager;
import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.activity.TsdChoiceLikeActivity;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.TsdContextHolder;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.preference.PreferenceManager;
import android.support.design.widget.TabLayout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import com.firedata.sdk.Firedata;
import com.lzy.okgo.callback.StringCallback;
import com.lzy.okgo.model.Response;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TsdTabLayout
extends TabLayout
implements TabLayout.OnTabSelectedListener {
    private boolean isInitTop;
    private List<String> label_idList;
    private String cache_title;
    private Context mContext;
    private TopTitleEntity topTitleEntity;
    private RenderListener mRenderListener;
    private static final String VERSION_KEY = "version_key";
    private ArrayList<String> tabTitleArray;
    private String feedType;
    private String appName;
    private static int versionName;

    public TsdTabLayout(Context context) {
        super(context);
        this.init(context);
    }

    public TsdTabLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public TsdTabLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void setDayTheme() {
        this.feedType = (String)TsdSPUtils.get(this.mContext, "arg_type_video", "article");
        this.setSelectedTabIndicatorColor(this.getResources().getColor(R.color.tpp_color_187cdc));
        this.setTabTextColors(this.getResources().getColor(R.color.tsd_color_222222), this.getResources().getColor(R.color.tpp_color_187cdc));
        this.setBackgroundColor(this.mContext.getResources().getColor(R.color.tsd_color_f4f5f6));
    }

    private void setNightTheme() {
        this.setBackgroundColor(this.mContext.getResources().getColor(R.color.tsd_color_252525));
        this.setSelectedTabIndicatorColor(this.getResources().getColor(R.color.tsd_color_707070));
        this.setTabTextColors(this.getResources().getColor(R.color.tsd_color_707070), this.getResources().getColor(R.color.tpp_color_187cdc));
    }

    private void initTheme() {
        if (TtCloudManager.getCurrentTheme() == 0) {
            this.setDayTheme();
        } else {
            this.setNightTheme();
        }
    }

    public void init(Context context) {
        this.mContext = context;
        this.label_idList = new ArrayList<String>();
        this.addOnTabSelectedListener(this);
        this.setTabMode(0);
        this.initTheme();
        this.cache_title = (String)TsdSPUtils.get(context, "pref_channel" + this.feedType, "");
        if (this.checkCacheDataValid(this.cache_title)) {
            this.renderConfig(this.cache_title);
        } else {
            TsdSPUtils.remove(context, "pref_channel" + this.feedType);
        }
        new RestApiImpl().getConfig(new ConfigObserver(), this.feedType);
    }

    private boolean checkCacheDataValid(String cache) {
        if (TextUtils.isEmpty((CharSequence)cache)) {
            return false;
        }
        TopTitleEntity entity = GsonUtil.GsonToBean(cache, TopTitleEntity.class);
        return null != entity;
    }

    public void onTabSelected(TabLayout.Tab tab) {
        int position = tab.getPosition();
        String text = (String)tab.getText();
        if (null == this.topTitleEntity || null == this.topTitleEntity.data) {
            return;
        }
        if (null == this.topTitleEntity.data.columns) {
            return;
        }
        if (position >= this.topTitleEntity.data.columns.size()) {
            return;
        }
        String label_id = this.topTitleEntity.data.columns.get((int)position).id;
        if (!TextUtils.isEmpty((CharSequence)text)) {
            Firedata.pageViewEnd((String)text);
        }
        Firedata.pageViewStart((String)label_id);
    }

    public void onTabUnselected(TabLayout.Tab tab) {
    }

    public void onTabReselected(TabLayout.Tab tab) {
    }

    private void renderConfig(String response) {
        if (TextUtils.isEmpty((CharSequence)response)) {
            return;
        }
        this.cache(response);
        try {
            this.topTitleEntity = GsonUtil.GsonToBean(response, TopTitleEntity.class);
            this.coldStart(this.topTitleEntity);
            this.tabTitleArray = this.getTabTitleArray(this.topTitleEntity);
            this.initTabLayout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void coldStart(TopTitleEntity topTitleEntity) {
        String enable;
        TopTitleEntity.Data data = topTitleEntity.data;
        if (null == data.coldStart) {
            return;
        }
        TopTitleEntity.ColdStart coldStart = data.coldStart;
        String appName = null == topTitleEntity.appName ? "" : topTitleEntity.appName;
        String string2 = enable = null == coldStart.enable ? "" : coldStart.enable;
        if (enable.equals("on") && this.isFirstLauncher()) {
            Intent intent = new Intent();
            intent.setClass(this.mContext, TsdChoiceLikeActivity.class);
            intent.putExtra("ACTION_COLDSTART", (Serializable)coldStart);
            intent.putExtra("ACTION_APP_NAME", appName);
            this.mContext.startActivity(intent);
        }
    }

    private synchronized void initTabLayout() {
        this.removeAllTabs();
        for (int i = 0; i < this.tabTitleArray.size(); ++i) {
            String tab = this.tabTitleArray.get(i);
            this.addTab(this.newTab().setText((CharSequence)tab));
        }
    }

    private ArrayList<String> getTabTitleArray(TopTitleEntity topTitleEntity) {
        List<TopTitleEntity.Columns> datas;
        this.label_idList.clear();
        if (null == topTitleEntity || null == topTitleEntity.data) {
            return null;
        }
        this.tabTitleArray = new ArrayList();
        this.appName = topTitleEntity.appName;
        if (null != this.mRenderListener) {
            this.mRenderListener.renderTabLayoutSuccess(topTitleEntity.data, this.appName);
        }
        if (null == (datas = topTitleEntity.data.columns) || datas.size() == 0) {
            return null;
        }
        for (TopTitleEntity.Columns data : datas) {
            String label_name = data.name;
            String label_id = data.id;
            this.tabTitleArray.add(label_name);
            this.label_idList.add(label_id);
        }
        return this.tabTitleArray;
    }

    private boolean isFirstLauncher() {
        SharedPreferences prefs;
        int lastVersion;
        int currentVersion = TsdTabLayout.getAppVersionCode(TsdContextHolder.getContext());
        if (currentVersion > (lastVersion = (prefs = PreferenceManager.getDefaultSharedPreferences((Context)TsdContextHolder.getContext())).getInt(VERSION_KEY, 0))) {
            prefs.edit().putInt(VERSION_KEY, currentVersion).apply();
            return true;
        }
        return false;
    }

    public void onResume() {
        this.initTheme();
    }

    public static int getAppVersionCode(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
            return pi.versionCode;
        }
        catch (Exception e) {
            Log.e((String)"VersionInfo", (String)"Exception", (Throwable)e);
            return versionName;
        }
    }

    public void setCallBack(RenderListener listener) {
        this.mRenderListener = listener;
        if (null != this.topTitleEntity) {
            this.mRenderListener.renderTabLayoutSuccess(this.topTitleEntity.data, this.appName);
        }
    }

    private void cache(String response) {
        TsdSPUtils.put(this.mContext, "pref_channel" + this.feedType, response);
    }

    public void retryRender() {
        new RestApiImpl().getConfig(new ConfigObserver(), this.feedType);
    }

    public static interface RenderListener {
        public void renderTabLayoutSuccess(TopTitleEntity.Data var1, String var2);

        public void renderTabLayoutFail();
    }

    private final class ConfigObserver
    extends StringCallback {
        private ConfigObserver() {
        }

        public void onError(Response<String> response) {
            super.onError(response);
            if (null != TsdTabLayout.this.mRenderListener && TextUtils.isEmpty((CharSequence)TsdTabLayout.this.cache_title)) {
                TsdTabLayout.this.mRenderListener.renderTabLayoutFail();
            }
        }

        public void onSuccess(Response<String> response) {
            String s = (String)response.body();
            TsdTabLayout.this.renderConfig(s);
        }
    }
}

