/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.presenter;

import ai.botbrain.ttcloud.sdk.util.LogUtil;
import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Environment;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class DownLoadApkManager {
    private Context mContext;
    private String apkName;
    private String savedName;
    private BroadcastReceiver downloadCompleteReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            File f = new File(DownLoadApkManager.this.sd_path + "/download/" + DownLoadApkManager.this.apkName);
            File f2 = new File(DownLoadApkManager.this.sd_path + "/download/" + DownLoadApkManager.this.apkName + ".apk");
            f.renameTo(f2);
            DownLoadApkManager.this.installApk();
        }
    };
    private String sd_path = Environment.getExternalStorageDirectory().getPath() + "//";

    public DownLoadApkManager(Context context) {
        this.mContext = context;
        this.mContext.registerReceiver(this.downloadCompleteReceiver, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
    }

    public void downloadApk(String apkUrl, String apkName) {
        this.apkName = apkName;
        Uri uri = Uri.parse((String)apkUrl);
        DownloadManager downloadManager = (DownloadManager)this.mContext.getSystemService("download");
        DownloadManager.Request request = new DownloadManager.Request(uri);
        request.setAllowedNetworkTypes(1 | 2);
        request.setAllowedOverRoaming(false);
        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
        String mimeString = mimeTypeMap.getMimeTypeFromExtension(MimeTypeMap.getFileExtensionFromUrl((String)apkUrl));
        request.setMimeType(mimeString);
        request.setNotificationVisibility(1);
        request.setTitle((CharSequence)apkName);
        request.setVisibleInDownloadsUi(true);
        LogUtil.i("DownLoadApkManager", this.generateSavedName(apkName));
        request.setDestinationInExternalPublicDir("/download", this.generateSavedName(apkName));
        downloadManager.enqueue(request);
    }

    private void installApk() {
        Intent i = new Intent("android.intent.action.VIEW");
        String filePath = Environment.getExternalStorageDirectory().getPath() + this.savedName + ".apk";
        i.setDataAndType(Uri.parse((String)("file://" + filePath)), "application/vnd.android.package-archive");
        this.mContext.startActivity(i);
    }

    private String generateSavedName(String apkName) {
        String savedName;
        try {
            savedName = URLEncoder.encode(apkName, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            savedName = apkName;
        }
        this.savedName = savedName;
        return savedName;
    }

    public boolean isDownload(String apkName) {
        File file = new File(this.sd_path + "/download/" + apkName);
        return file.exists();
    }
}

