/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.fragment;

import ai.botbrain.ttcloud.api.TtCloudManager;
import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.activity.TsdH5ReaderActivity;
import ai.botbrain.ttcloud.sdk.adapter.GraphicAdapter;
import ai.botbrain.ttcloud.sdk.banner.Banner;
import ai.botbrain.ttcloud.sdk.banner.listener.OnBannerListener;
import ai.botbrain.ttcloud.sdk.fragment.LazyLoadFragment;
import ai.botbrain.ttcloud.sdk.model.BuriedPointEvent;
import ai.botbrain.ttcloud.sdk.model.DislikeEvent;
import ai.botbrain.ttcloud.sdk.model.RecommendEntity;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.model.TsdFontSizeEvent;
import ai.botbrain.ttcloud.sdk.net.RestApi;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.util.BannerGlideImageloader;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.LogUtil;
import ai.botbrain.ttcloud.sdk.util.TimeUtil;
import ai.botbrain.ttcloud.sdk.util.TsdContextHolder;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;
import ai.botbrain.ttcloud.sdk.widget.LoadingView;
import ai.botbrain.ttcloud.sdk.widget.NestedListView;
import ai.botbrain.ttcloud.sdk.widget.UpdateStateView;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import cn.bingoogolapple.refreshlayout.BGANormalRefreshViewHolder;
import cn.bingoogolapple.refreshlayout.BGARefreshLayout;
import cn.bingoogolapple.refreshlayout.BGARefreshViewHolder;
import com.lzy.okgo.callback.StringCallback;
import com.lzy.okgo.model.Response;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class GraphicFragment
extends LazyLoadFragment
implements AdapterView.OnItemClickListener,
LoadingView.OnRetryListener,
BGARefreshLayout.BGARefreshLayoutDelegate,
OnBannerListener,
GraphicAdapter.NotiListener {
    private static final String TAG = GraphicFragment.class.getSimpleName();
    private Context mContext;
    private boolean PULL_TO_REFRESH = true;
    private static final String EXTRA_URL = "extra_url";
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";
    private static final String ARG_PARAM3 = "param3";
    private int st = 0;
    private int position;
    private String id;
    private String cacheData;
    private NestedListView mListView;
    private UpdateStateView tsd_usv;
    private LoadingView mLoadingView;
    private GraphicAdapter mAdapter;
    private List<RecommendEntity.Data> datas;
    private BGARefreshLayout mRefreshLayout;
    private RestApi restApi;
    private FeedDataObserver feedDataObserver;
    private TopTitleEntity.Columns mColumns;
    private boolean isFirstRefresh = false;
    private List<RecommendEntity.Banner> mBanners;

    public static GraphicFragment newInstance(int position, TopTitleEntity.Columns columns) {
        String id2 = null == columns ? "" : columns.id;
        GraphicFragment fragment = new GraphicFragment();
        Bundle args = new Bundle();
        args.putInt(ARG_PARAM1, position);
        args.putString(ARG_PARAM2, id2);
        args.putSerializable(ARG_PARAM3, (Serializable)columns);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.restApi = new RestApiImpl();
        this.datas = new ArrayList<RecommendEntity.Data>();
        this.feedDataObserver = new FeedDataObserver();
        if (this.getArguments() != null) {
            this.position = this.getArguments().getInt(ARG_PARAM1);
            this.id = this.getArguments().getString(ARG_PARAM2);
            this.mColumns = (TopTitleEntity.Columns)this.getArguments().getSerializable(ARG_PARAM3);
        }
    }

    @Override
    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = super.onCreateView(inflater, container, savedInstanceState);
        this.initRefreshLayout(view);
        return view;
    }

    private void setMyTheme() {
        int i = TtCloudManager.getCurrentTheme();
        if (i == 0) {
            this.getActivity().setTheme(R.style.tsd_theme_default);
        } else if (i == 1) {
            this.getActivity().setTheme(R.style.tsd_theme_night);
        }
    }

    @Override
    protected int setContentView() {
        this.setMyTheme();
        return R.layout.tsd_fragment_graphic;
    }

    private void initRefreshLayout(View view) {
        this.mRefreshLayout = (BGARefreshLayout)view.findViewById(R.id.rl_modulename_refresh);
        this.mRefreshLayout.setDelegate((BGARefreshLayout.BGARefreshLayoutDelegate)this);
        BGANormalRefreshViewHolder refreshViewHolder = new BGANormalRefreshViewHolder(this.mContext, true);
        refreshViewHolder.setPullDownRefreshText("\u4e0b\u62c9\u63a8\u8350");
        refreshViewHolder.setRefreshingText("\u52aa\u529b\u63a8\u8350\u4e2d");
        refreshViewHolder.setReleaseRefreshText("\u91ca\u653e\u63a8\u8350");
        refreshViewHolder.setLoadingMoreText("\u52aa\u529b\u63a8\u8350\u4e2d");
        this.mRefreshLayout.setRefreshViewHolder((BGARefreshViewHolder)refreshViewHolder);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mLoadingView = (LoadingView)((Object)this.findViewById(R.id.loading_view));
        this.tsd_usv = (UpdateStateView)((Object)this.findViewById(R.id.tsd_usv));
        this.mLoadingView.setOnRetryListener(this);
        this.mListView = (NestedListView)((Object)this.findViewById(R.id.listview));
        this.mListView.setOnItemClickListener(this);
        this.mAdapter = new GraphicAdapter(this.mContext, this.mColumns, this.datas);
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mAdapter.setNotiListener(this);
        this.lazyLoadCache();
        this.isCanLoadData();
    }

    private void lazyLoadCache() {
        this.cacheData = (String)TsdSPUtils.get(TsdContextHolder.getContext(), "pref_graphic" + this.position, "");
        this.renderFeedList(this.cacheData, true, true);
    }

    @Override
    protected void lazyLoad() {
        this.isFirstRefresh = true;
        this.mRefreshLayout.beginRefreshing();
    }

    private void showtsd_usv(final int count) {
        this.tsd_usv.postDelayed(new Runnable(){

            @Override
            public void run() {
                GraphicFragment.this.tsd_usv.show(count);
            }
        }, 1000L);
    }

    private void refresh(RecommendEntity entity, boolean isRenderCache) {
        this.mRefreshLayout.endRefreshing();
        if (!entity.data.isEmpty() && !isRenderCache) {
            this.showtsd_usv(entity.data.size());
        } else if (!isRenderCache) {
            this.showtsd_usv(0);
        }
        this.removeTop(this.datas);
        this.removeSeeHere(this.datas);
        this.injectSeeHere(entity.data);
        this.datas.addAll(0, entity.data);
    }

    private void loadMore(RecommendEntity entity) {
        this.mRefreshLayout.endLoadingMore();
        this.mRefreshLayout.endRefreshing();
        this.datas.addAll(entity.data);
    }

    public synchronized void renderFeedList(String json, boolean PULL_TO_REFRESH, boolean isRenderCache) {
        try {
            RecommendEntity entity = GsonUtil.GsonToBean(json, RecommendEntity.class);
            this.renderBanner(entity);
            TsdSPUtils.put(TsdContextHolder.getContext(), "pref_graphic" + this.position, json);
            this.cacheData = json;
            if (PULL_TO_REFRESH) {
                this.refresh(entity, isRenderCache);
            } else {
                this.loadMore(entity);
            }
            this.mAdapter.notifyDataSetChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renderBanner(RecommendEntity entity) {
        ArrayList<String> images = new ArrayList<String>();
        ArrayList<String> titles = new ArrayList<String>();
        if (this.mBanners != null) {
            this.mBanners.clear();
        }
        this.mBanners = entity.banner;
        if (null == this.mBanners || this.mBanners.size() == 0) {
            return;
        }
        for (RecommendEntity.Banner banner : this.mBanners) {
            String url = banner.url;
            String title = banner.title;
            images.add(url);
            titles.add(title);
        }
        View headerView = View.inflate((Context)this.mContext, (int)R.layout.tsd_custom_header, null);
        Banner banner = (Banner)headerView.findViewById(R.id.banner);
        banner.setImages(images);
        banner.setImageLoader(new BannerGlideImageloader());
        banner.setBannerStyle(5);
        banner.setBannerTitles(titles);
        banner.start();
        banner.setOnBannerListener(this);
        this.mRefreshLayout.setCustomHeaderView(headerView, true);
    }

    private String getPubTime2() {
        String pub_time;
        try {
            RecommendEntity.Data data = this.datas.get(this.datas.size() - 1);
            RecommendEntity.Data2 data2 = data.data;
            pub_time = data2.pub_time;
        }
        catch (Exception e) {
            pub_time = "0";
        }
        return pub_time;
    }

    private void removeTop(List datas) {
        if (null == datas || datas.size() == 0) {
            return;
        }
        Object o = datas.get(0);
        if (o instanceof RecommendEntity.Data) {
            String flag;
            RecommendEntity.Data data = (RecommendEntity.Data)o;
            String string2 = flag = null == data.flag ? "" : data.flag;
            if (flag.equals("top")) {
                datas.remove(0);
            }
        }
    }

    private void removeSeeHere(List datas) {
        Iterator iterator = datas.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof RecommendEntity.Data)) continue;
            RecommendEntity.Data i = (RecommendEntity.Data)o;
            if (!i.type.equals("seeHere")) continue;
            iterator.remove();
        }
    }

    private void injectSeeHere(List<RecommendEntity.Data> datas) {
        if (this.datas.size() <= 0 || datas.size() <= 0) {
            return;
        }
        RecommendEntity.Data data = new RecommendEntity.Data();
        data.type = "seeHere";
        datas.add(data);
    }

    public void onSaveInstanceState(Bundle outState) {
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        RecommendEntity.Data data = this.datas.get(position);
        this.mAdapter.notifyDataSetChanged();
        if (data.type.equals("seeHere")) {
            this.datas.remove(position);
            this.mListView.smoothScrollToPosition(0);
            this.mRefreshLayout.beginRefreshing();
        } else {
            this.goToReaderActivity(data);
        }
    }

    private void goToReaderActivity(RecommendEntity.Data data) {
        data.data.has_read = true;
        RecommendEntity.Data2 data2 = data.data;
        String iid = null == data2.iid ? "" : data2.iid;
        Object alg = null == data2.alg ? "" : data2.alg;
        Intent intent = new Intent();
        intent.setClass(this.mContext, TsdH5ReaderActivity.class);
        intent.putExtra("extra_iid", iid);
        intent.putExtra("extra_column_id", this.id);
        EventBus.getDefault().post((Object)new BuriedPointEvent("click", iid, alg, null, null));
        this.startActivity(intent);
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mContext = activity;
    }

    public void onDetach() {
        super.onDetach();
        this.mContext = null;
    }

    @Override
    public void onRetry() {
        this.mLoadingView.notifyDataChanged(LoadingView.State.ing);
        this.PULL_TO_REFRESH = true;
        this.restApi.feedList(this.feedDataObserver, this.id, 0, TimeUtil.getTime());
    }

    public void onStart() {
        super.onStart();
        EventBus.getDefault().register((Object)this);
    }

    public void onStop() {
        super.onStop();
        EventBus.getDefault().unregister((Object)this);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onMessageEvent(DislikeEvent event) {
        BaseAdapter adapter = event.adapter;
        if (this.mAdapter != adapter) {
            return;
        }
        int position = event.position;
        LogUtil.i(TAG, "\u8981\u5220\u9664\u7684\u4f4d\u7f6e\uff1a" + position);
        try {
            List<RecommendEntity.Data> das = this.datas;
            RecommendEntity.Data data = das.get(position);
            String title = data.data.title;
            LogUtil.i(TAG, title);
            this.datas.remove(position);
            this.mAdapter.notifyDataSetChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onMessageEvent(TsdFontSizeEvent event) {
        int font_size = event.font_size;
        TsdContextHolder.setFont_size(font_size);
        this.mAdapter.notifyDataSetChanged();
    }

    public void onBGARefreshLayoutBeginRefreshing(BGARefreshLayout refreshLayout) {
        this.PULL_TO_REFRESH = true;
        String time = this.isFirstRefresh ? "0" : this.getPubTime2();
        this.restApi.feedList(this.feedDataObserver, this.id, 0, time);
        this.isFirstRefresh = false;
    }

    public boolean onBGARefreshLayoutBeginLoadingMore(BGARefreshLayout refreshLayout) {
        this.PULL_TO_REFRESH = false;
        ++this.st;
        this.restApi.feedList(this.feedDataObserver, this.id, this.st, null);
        return true;
    }

    @Override
    public void OnBannerClick(int position) {
        String iid = this.mBanners.get((int)position).linkUrl;
        String linkType = this.mBanners.get((int)position).linkType;
        if (linkType.equals("1")) {
            return;
        }
        if (linkType.equals("3")) {
            Intent intent = new Intent();
            intent.setClass(this.mContext, TsdH5ReaderActivity.class);
            intent.putExtra("extra_iid", iid);
            intent.putExtra("extra_column_id", this.id);
            this.startActivity(intent);
            return;
        }
        if (linkType.equals("2")) {
            Intent intent = new Intent();
            intent.putExtra(EXTRA_URL, iid);
            intent.setClass(this.mContext, TsdH5ReaderActivity.class);
            this.mContext.startActivity(intent);
        }
    }

    @Override
    public void notifyData() {
        this.mAdapter.notifyDataSetChanged();
    }

    public void scrollToTop(boolean smooth) {
        if (this.mListView != null) {
            if (smooth) {
                this.mListView.smoothScrollToPosition(0);
            } else {
                this.mListView.setSelection(0);
            }
        }
    }

    public void setOpeningState(boolean isOpening) {
        if (isOpening) {
            this.scrollToTop(false);
            this.setRefreshEnable(false);
            this.setTouchScrollable(false);
        } else {
            this.scrollToTop(false);
            this.setRefreshEnable(true);
            this.setTouchScrollable(true);
        }
    }

    public void setRefreshEnable(boolean refreshEnable) {
        if (this.mRefreshLayout != null) {
            this.mRefreshLayout.setEnabled(refreshEnable);
        }
    }

    public void setTouchScrollable(boolean scrollable) {
        if (this.mListView != null) {
            this.mListView.setTouchScrollable(scrollable);
        }
    }

    private final class FeedDataObserver
    extends StringCallback {
        private FeedDataObserver() {
        }

        public void onError(Response<String> response) {
            super.onError(response);
            if (TextUtils.isEmpty((CharSequence)GraphicFragment.this.cacheData)) {
                GraphicFragment.this.mLoadingView.notifyDataChanged(LoadingView.State.error);
            }
            if (response.getException() instanceof UnknownHostException) {
                GraphicFragment.this.tsd_usv.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        GraphicFragment.this.tsd_usv.showUnknownHostException();
                    }
                }, 2000L);
            }
            GraphicFragment.this.mRefreshLayout.endRefreshing();
            GraphicFragment.this.mRefreshLayout.endLoadingMore();
        }

        public void onSuccess(Response<String> response) {
            final String json = (String)response.body();
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    GraphicFragment.this.mLoadingView.notifyDataChanged(LoadingView.State.done);
                    GraphicFragment.this.renderFeedList(json, GraphicFragment.this.PULL_TO_REFRESH, false);
                }
            }, 1000L);
        }
    }
}

