/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.disLike;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.disLike.DensityUtils;
import ai.botbrain.ttcloud.sdk.disLike.FitPopupWindow;
import ai.botbrain.ttcloud.sdk.disLike.ScreenUtils;
import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

public class FitPopupUtil
implements View.OnClickListener {
    private View contentView;
    private Activity context;
    private TextView reason1;
    private TextView reason2;
    private TextView reason3;
    private TextView btnCommit;
    private boolean reason1Selected;
    private boolean reason2Selected;
    private boolean reason3Selected;
    private FitPopupWindow mPopupWindow;
    private OnCommitClickListener listener;

    public FitPopupUtil(Activity context) {
        this.context = context;
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        this.contentView = inflater.inflate(R.layout.tpp_layout_popupwindow, null);
        this.reason1 = (TextView)this.contentView.findViewById(R.id.tv_reason1);
        this.reason2 = (TextView)this.contentView.findViewById(R.id.tv_reason2);
        this.reason3 = (TextView)this.contentView.findViewById(R.id.tv_reason3);
        this.btnCommit = (TextView)this.contentView.findViewById(R.id.btn_commit);
        this.reason1.setOnClickListener((View.OnClickListener)this);
        this.reason2.setOnClickListener((View.OnClickListener)this);
        this.reason3.setOnClickListener((View.OnClickListener)this);
    }

    public void setOnClickListener(OnCommitClickListener listener) {
        this.listener = listener;
    }

    public View showPopup(View anchorView) {
        if (this.mPopupWindow == null) {
            this.mPopupWindow = new FitPopupWindow(this.context, ScreenUtils.getScreenWidth((Context)this.context) - DensityUtils.dp2px(20.0f), -2);
        }
        this.mPopupWindow.setView(this.contentView, anchorView);
        this.mPopupWindow.show();
        return this.contentView;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.tv_reason1) {
            this.reason1Selected = !this.reason1Selected;
            this.reason1.setSelected(this.reason1Selected);
        } else if (id2 == R.id.tv_reason2) {
            this.reason2Selected = !this.reason2Selected;
            this.reason2.setSelected(this.reason2Selected);
        } else if (id2 == R.id.tv_reason3) {
            this.reason3Selected = !this.reason3Selected;
            this.reason3.setSelected(this.reason3Selected);
        } else if (id2 == R.id.btn_commit) {
            if (this.listener != null) {
                this.listener.onClick(this.getReason());
            }
            this.mPopupWindow.dismiss();
        }
        if (this.reason1Selected || this.reason2Selected || this.reason3Selected) {
            this.btnCommit.setOnClickListener((View.OnClickListener)this);
            this.btnCommit.setText((CharSequence)"\u786e\u5b9a");
        } else {
            this.btnCommit.setOnClickListener(null);
            this.btnCommit.setText((CharSequence)"\u4e0d\u611f\u5174\u8da3");
        }
    }

    public String getReason() {
        String content1 = this.reason1Selected ? this.reason1.getText().toString() + "," : "";
        String content2 = this.reason2Selected ? this.reason2.getText().toString() + "," : "";
        String content3 = this.reason3Selected ? this.reason3.getText().toString() + "," : "";
        String s = content1 + content2 + content3;
        return s.substring(0, s.length() - 1);
    }

    public static interface OnCommitClickListener {
        public void onClick(String var1);
    }
}

