/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.adapter;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.model.MovieListEntity;
import ai.botbrain.ttcloud.sdk.presenter.GetInjectJsNet;
import ai.botbrain.ttcloud.sdk.presenter.JsPresenter;
import ai.botbrain.ttcloud.sdk.util.FireDataManager;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import java.util.List;

public class TsdTvAdapter_Search
extends BaseAdapter {
    private Context mContext;
    private List<MovieListEntity.Episodes> episodesList;
    private MovieListEntity.Data mData;
    private String channel;
    private String iid;

    public TsdTvAdapter_Search(Context context, MovieListEntity.Data data) {
        this.episodesList = data.episodes;
        this.mContext = context;
        this.mData = data;
        this.channel = data.channel;
        this.iid = data.iid;
    }

    public int getCount() {
        return null == this.episodesList ? 0 : this.episodesList.size();
    }

    public Object getItem(int position) {
        return this.episodesList.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        if (convertView == null || convertView.getTag() == null) {
            viewHolder = new ViewHolder();
            convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_tv, null);
            viewHolder.btnNum = (Button)convertView.findViewById(R.id.btn_num);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        MovieListEntity.Episodes entity = this.episodesList.get(position);
        final String num_text = this.getbtnNumText(entity);
        boolean is_free = entity.sources.get((int)0).is_free;
        viewHolder.btnNum.setText((CharSequence)num_text);
        if (is_free) {
            viewHolder.btnNum.setTextColor(this.mContext.getResources().getColor(R.color.tsd_black));
        } else {
            viewHolder.btnNum.setTextColor(this.mContext.getResources().getColor(R.color.tsd_gray));
        }
        viewHolder.btnNum.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FireDataManager.clickCsn(TsdTvAdapter_Search.this.channel, ((TsdTvAdapter_Search)TsdTvAdapter_Search.this).mData.title, TsdTvAdapter_Search.this.iid, num_text);
                final Handler mainHandler = new Handler(Looper.getMainLooper());
                if (((MovieListEntity.Episodes)((TsdTvAdapter_Search)TsdTvAdapter_Search.this).episodesList.get((int)position)).sources.get((int)0).is_free) {
                    TsdTvAdapter_Search.this.notifyDataSetChanged();
                    final String url = ((MovieListEntity.Episodes)((TsdTvAdapter_Search)TsdTvAdapter_Search.this).episodesList.get((int)position)).sources.get((int)0).url;
                    if (JsPresenter.getInstance().isEmpty()) {
                        new Thread(){

                            @Override
                            public void run() {
                                super.run();
                                JsPresenter.getInstance().setData(GetInjectJsNet.getInstance().getJsHttp());
                                mainHandler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        FireDataManager.play(((TsdTvAdapter_Search)TsdTvAdapter_Search.this).mData.channel);
                                        JsPresenter.getInstance().StartPlayback(TsdTvAdapter_Search.this.mContext, url, ((TsdTvAdapter_Search)TsdTvAdapter_Search.this).mData.title, TsdTvAdapter_Search.this.iid);
                                    }
                                });
                            }
                        }.start();
                    } else {
                        FireDataManager.play(((TsdTvAdapter_Search)TsdTvAdapter_Search.this).mData.channel);
                        JsPresenter.getInstance().StartPlayback(TsdTvAdapter_Search.this.mContext, url, ((TsdTvAdapter_Search)TsdTvAdapter_Search.this).mData.title, TsdTvAdapter_Search.this.iid);
                    }
                }
            }
        });
        return convertView;
    }

    private String getbtnNumText(MovieListEntity.Episodes entity) {
        String s;
        if (!this.channel.equals("\u7efc\u827a")) {
            s = entity.episode;
        } else {
            String text = entity.episode;
            String str1 = text.substring(0, 4);
            String str2 = text.substring(4, 6);
            String str3 = text.substring(6, 8);
            s = str1 + "-" + str2 + "-" + str3;
        }
        return s;
    }

    private class ViewHolder {
        private Button btnNum;

        private ViewHolder() {
        }
    }
}

