/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.api;

import ai.botbrain.ttcloud.api.TtCloudListener;
import ai.botbrain.ttcloud.api.TtcClient;
import ai.botbrain.ttcloud.sdk.activity.TsdH5ReaderActivity;
import ai.botbrain.ttcloud.sdk.activity.TsdSearchActivity;
import ai.botbrain.ttcloud.sdk.fragment.IndexFragment;
import ai.botbrain.ttcloud.sdk.model.ThemeEvent;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.util.Ad360Mamager;
import ai.botbrain.ttcloud.sdk.util.FireDataManager;
import ai.botbrain.ttcloud.sdk.util.OkHttpManager;
import ai.botbrain.ttcloud.sdk.util.TimeUtil;
import ai.botbrain.ttcloud.sdk.util.TsdContextHolder;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import org.greenrobot.eventbus.EventBus;

public class TtCloudManager {
    public static boolean DEBUG = false;
    private static boolean mShowResponse = false;
    public static boolean LOG = true;
    private static String appId;
    private static String sid;

    public static void init(Application app, TtcClient client) {
        try {
            ApplicationInfo appInfo = app.getPackageManager().getApplicationInfo(app.getPackageName(), 128);
            appId = appInfo.metaData.getString("TTC_APPID");
            if (TextUtils.isEmpty((CharSequence)appId)) {
                throw new IllegalArgumentException("--\u8bf7\u5728\u914d\u7f6e\u6e05\u5355\u6587\u4ef6\u4e2d\u6dfb\u52a0 TTC_APPID-----");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (null != client) {
            LOG = client.isShowLog();
            mShowResponse = client.isShowResponse();
            DEBUG = client.isDebug();
        }
        TtCloudManager.hideComment(client);
        TsdContextHolder.initialContext((Context)app);
        OkHttpManager.initOkGo(app, mShowResponse);
        Ad360Mamager.initSdk(false);
        sid = TimeUtil.getTimestamp();
        new RestApiImpl().getYouKuConfig();
        FireDataManager.init(app, appId, "");
    }

    private static void hideComment(TtcClient client) {
        if (null != client && client.isHideComment()) {
            TsdContextHolder.setHideComment();
        }
    }

    public static void init(Application application) {
        TtCloudManager.init(application, null);
    }

    public static void hideActionBar(boolean b) {
        TsdContextHolder.setIsShowActionBar(b);
    }

    public static String getAppId() {
        return appId;
    }

    public static String getSid() {
        return sid;
    }

    public static void setCallBack(TtCloudListener ttCloudListener) {
        TsdContextHolder.initTtCloudListener(ttCloudListener);
    }

    public static void login(TtCloudListener.User user) {
        TsdContextHolder.initalUser(user);
    }

    public static void logout() {
        TsdSPUtils.remove(TsdContextHolder.getContext(), "pre_user_id");
        TsdContextHolder.clearUser();
    }

    public static boolean isLogin() {
        return TsdContextHolder.isLogin();
    }

    public static void setNotScroll() {
        TsdContextHolder.setCanScroll(false);
    }

    public static void setLoadingErrorView(int loadingErrorView) {
        TsdContextHolder.showLoadErrorView(loadingErrorView);
    }

    protected static void setFontSize(int size) {
        TsdContextHolder.setFont_size(size);
    }

    public static void openArticleDetailActivity(Context context, String extra_iid) {
        Intent intent = new Intent();
        intent.setClass(context, TsdH5ReaderActivity.class);
        intent.putExtra("extra_iid", extra_iid);
        context.startActivity(intent);
    }

    public static void openSearchActivity(Context context) {
        Intent intent = new Intent();
        intent.setClass(context, TsdSearchActivity.class);
        context.startActivity(intent);
    }

    public static void setAppId(String appId) {
        TtCloudManager.appId = appId;
    }

    public static IndexFragment getVideoFragment() {
        return IndexFragment.newInstance("video");
    }

    public static IndexFragment getNewsFragment() {
        return IndexFragment.newInstance("article");
    }

    public static IndexFragment getDefaultFragment() {
        return IndexFragment.newInstance();
    }

    public static void setNightTheme() {
        try {
            TsdSPUtils.put(TsdContextHolder.getContext(), "pre_theme", 1);
            EventBus.getDefault().post((Object)new ThemeEvent(1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setClearNightTheme() {
        TsdSPUtils.put(TsdContextHolder.getContext(), "pre_theme", 0);
        EventBus.getDefault().post((Object)new ThemeEvent(0));
    }

    public static int getCurrentTheme() {
        return (Integer)TsdSPUtils.get(TsdContextHolder.getContext(), "pre_theme", 0);
    }

    static {
        sid = "";
    }
}

