package ai.botbrain.ttcloud.sdk.util;

import android.content.Context;

public class Util {

	public static float getScreenDensity(Context context) {
		return context.getResources().getDisplayMetrics().density;
	}

	public static int dip2px(Context context, float px) {
		final float scale = getScreenDensity(context);
		return (int) (px * scale + 0.5);
	}

	public static String timePadding(long second, long maxPadding) {
		long pad = System.currentTimeMillis() / 1000 - second;
		if (pad > maxPadding) {
			return null;
		}
		if (pad < 60) {
			return "刚刚";
		}
		if (pad < 60 * 60) {
			return pad / 60 + "分钟前";
		}
		if (pad < 24 * 60 * 60) {
			return pad / (60 * 60) + "小时前";
		}
		return pad / (24 * 60 * 60) + "天前";
	}

}
