package ai.botbrain.ttcloud.sdk.util;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/4/21.
 */

import android.content.Context;
import android.view.Gravity;
import android.widget.Toast;

public class ToastUtil {
    private static Toast toast;

    public static void showShort(Context context, CharSequence sequence) {
        if (toast == null) {
            toast = Toast.makeText(context, sequence, Toast.LENGTH_SHORT);
        } else {
            toast.setText(sequence);
        }
        toast.show();
    }

    public static void showShort(Context context, int message) {
        if (null == toast) {
            toast = Toast.makeText(context, message, Toast.LENGTH_SHORT);
            // toast.setGravity(Gravity.CENTER, 0, 0);
        } else {
            toast.setText(message);
        }
        toast.show();
    }

    public static void showLong(Context context, CharSequence message) {
        if (null == toast) {
            toast = Toast.makeText(context, message, Toast.LENGTH_LONG);
            // toast.setGravity(Gravity.CENTER, 0, 0);
        } else {
            toast.setText(message);
        }
        toast.show();
    }

    public static void showLong(Context context, int message) {
        if (null == toast) {
            toast = Toast.makeText(context, message, Toast.LENGTH_LONG);
            // toast.setGravity(Gravity.CENTER, 0, 0);
        } else {
            toast.setText(message);
        }
        toast.show();
    }

    public static void show(Context context, CharSequence sequence, int duration) {
        if (toast == null) {
            toast = Toast.makeText(context, sequence, duration);
        } else {
            toast.setText(sequence);
        }
        toast.show();
    }

    public static void showCenter(Context context, CharSequence sequence, int duration) {
        if (toast == null) {
            toast = Toast.makeText(context, sequence, duration);
            toast.setGravity(Gravity.CENTER, 0, 0);
        } else {
            toast.setText(sequence);
        }
        toast.show();
    }

    public static void hideToast() {
        if (toast != null) {
            toast.cancel();
        }
    }
}

