package ai.botbrain.ttcloud.sdk.util;


import android.app.Application;

import com.lzy.okgo.OkGo;
import com.lzy.okgo.interceptor.HttpLoggingInterceptor;

import java.util.logging.Level;

import okhttp3.OkHttpClient;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/4/15.
 */
public class OkHttpManager {

    public static void initOkGo(Application app, boolean mShowResponse) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor("NET_INFO");
        loggingInterceptor.setPrintLevel(HttpLoggingInterceptor.Level.BODY);
        loggingInterceptor.setColorLevel(Level.INFO);
        if (mShowResponse)
            builder.addInterceptor(loggingInterceptor);

        OkGo.getInstance().init(app)
                .setOkHttpClient(builder.build())
                .setRetryCount(3);
    }

}
