package ai.botbrain.ttcloud.sdk.util;

import android.app.Application;

import com.firedata.sdk.Firedata;
import com.firedata.sdk.Props;
import com.firedata.sdk.Tracker;
import com.qq.e.ads.nativ.NativeMediaADData;

import ai.botbrain.ttcloud.api.TtCloudManager;
import ai.botbrain.ttcloud.sdk.model.RecommendEntity;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class FireDataManager {
    private static final String TAG = FireDataManager.class.getSimpleName();
    private static String mAppId;

    public static void init(Application application, String appId, String appKey) {
        mAppId = appId;
        Firedata.init(application, "FDU5D2P34", appKey);
        Firedata.setDebug(TtCloudManager.DEBUG);
        Firedata.enableCrashReporting();
        Firedata.enableForegroundTracking(application);
    }

    public static String getGuid() {
        String guid = "";
        try {
            guid = Tracker.getInstance().getGuidSync();
        } catch (Exception e) {
            e.printStackTrace();
        }
        LogUtil.i(TAG, "guid" + guid);
        if (null == guid || guid.equals("")) {
            return "1";
        }
        return guid;
    }

    public static void clickMore() {
        try {
            Props props = new Props();
            props.event("sid", TtCloudManager.getSid())
                    .event("app_name", mAppId)
                    .event("uid", Firedata.getGuid());
            Firedata.event("recommend", "more", props);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void qqAdClick(NativeMediaADData ad) {
        try {
            Props props = new Props();
            props.event("des", ad.getDesc())
                    .event("sid", TtCloudManager.getSid())
                    .event("title", ad.getTitle())
                    .event("app_name", mAppId)
                    .event("imgUrl", ad.getImgUrl());
            Firedata.event("recommend", "ad_click", props);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void botAdClick(RecommendEntity.Data2 data1) {
        try {
            Props props = new Props();
            props.event("des", data1.des)
                    .event("sid", TtCloudManager.getSid())
                    .event("title", data1.title)
                    .event("app_name", mAppId)
                    .event("pic_url", data1.pic_url);
            Firedata.event("recommend", "ad_click", props);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void qqAdShow(NativeMediaADData adData) {
        try {
            Props props = new Props();
            props.event("des", adData.getDesc())
                    .event("sid", TtCloudManager.getSid())
                    .event("title", adData.getTitle())
                    .event("app_name", mAppId)
                    .event("imgUrl", adData.getImgUrl());
            Firedata.event("recommend", "ad_show", props);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void botAdShow(RecommendEntity.Data data) {
        try {
            RecommendEntity.Data2 data2 = data.data;
            Props props = new Props();
            props.event("des", data2.des)
                    .event("title", data2.title)
                    .event("type", data2.type)
                    .event("app_name", mAppId)
                    .event("sid", TtCloudManager.getSid());
            Firedata.event("recommend", "ad_show", props);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sec_cat_click(TopTitleEntity.SubColumns labelData) {
        try {
            Props props = new Props();
            props.event("sid", TtCloudManager.getSid()).event("uid", FireDataManager.getGuid()).event("app_name", mAppId);
            Firedata.event(labelData.name, "sec_cat_click", props);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void refresh(String category) {
        try {
            Props props = new Props();
            props.event("sid", TtCloudManager.getSid()).event("app_name", mAppId);
            Firedata.event(category, "refresh", props);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadMore(String category) {
        try {
            Props props = new Props();
            props.event("sid", TtCloudManager.getSid()).event("app_name", mAppId);
            Firedata.event(category, "load_more", props);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void clickContent(String category, String name, String iid) {
        try {
            Props props = new Props();
            props.event("sid", TtCloudManager.getSid())
                    .event("type", "movie")
                    .event("name", name)
                    .event("app_name", mAppId)
                    .event("iid", iid);
            Firedata.event(category, "c_click", props);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void clickCsn(String category, String name, String iid, String csn) {
        try {
            Props props = new Props();
            props.event("sid", TtCloudManager.getSid())
                    .event("name", name)
                    .event("csn", csn)
                    .event("app_name", mAppId)
                    .event("iid", iid);
            Firedata.event(category, "select_csn", props);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void play(String category) {
        try {
            Props props = new Props();
            props.event("sid", TtCloudManager.getSid()).event("app_name", mAppId);
            Firedata.event(category, "play", props);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
