package ai.botbrain.ttcloud.sdk.model;

import com.google.gson.annotations.SerializedName;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class TopTitleEntity implements Serializable {

    @SerializedName("app_name")
    public String appName;

    @SerializedName("data")
    public Data data;

    public static class Data implements Serializable {
        public List<Columns> columns;
        public ColdStart coldStart;
        public Theme theme;
        public String type;
    }

    public static class Columns implements Serializable {
        public List<SubColumns> subColumns;
        public String name;
        public String id;
        public String type;

        /**
         * 1 自动
         * 2 右侧小图
         * 3 单张大图
         */
        public String compose;
    }

    public static class SubColumns implements Serializable {
        public String name;
        public String id;
        public boolean isSelected;
    }

    public static class Theme {
        public String name;
    }

    public static class ColdStart implements Serializable {
        public String enable;
        public String confirm;
        public String custom;
        public ArrayList<Map> tags;
    }


}