package ai.botbrain.ttcloud.sdk.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListView;

import com.firedata.sdk.Firedata;
import com.lzy.okgo.callback.StringCallback;
import com.lzy.okgo.model.Response;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.ArrayList;
import java.util.List;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.TsdConstant;
import ai.botbrain.ttcloud.sdk.activity.TsdH5ReaderActivity;
import ai.botbrain.ttcloud.sdk.adapter.RecommendHomeAdapter;
import ai.botbrain.ttcloud.sdk.model.BuriedPointEvent;
import ai.botbrain.ttcloud.sdk.model.RecommendEntity;
import ai.botbrain.ttcloud.sdk.model.StopVideoEvent;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.net.RestApi;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.util.FireDataManager;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.TimeUtil;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;
import ai.botbrain.ttcloud.sdk.widget.LoadingView;
import cn.bingoogolapple.refreshlayout.BGANormalRefreshViewHolder;
import cn.bingoogolapple.refreshlayout.BGARefreshLayout;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class RecommendHomeFragment extends LazyLoadFragment implements LoadingView.OnRetryListener, AdapterView.OnItemClickListener, BGARefreshLayout.BGARefreshLayoutDelegate, RecommendHomeAdapter.NotiListener {
    public Context mContext;

    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";

    private LoadingView mLoadingView;
    public ListView mListView;

    private String cacheData;
    private int position;
    private int pageCurrent = 0;
    private int secondDirectoryPosition;
    private boolean PULL_TO_REFRESH = true;
    private String mSid;
    private List<RecommendEntity.Data> mDatas;
    private RecommendHomeAdapter recommendHomeAdapter;

    private TopTitleEntity.Columns mColumns;

    private FeedListObserver feedListObserver;
    private RestApi restApi;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());

    public static RecommendHomeFragment newInstance(int position, TopTitleEntity.Columns columns) {
        RecommendHomeFragment fragment = new RecommendHomeFragment();
        Bundle args = new Bundle();
        args.putInt(ARG_PARAM1, position);
        args.putSerializable(ARG_PARAM2, columns);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mDatas = new ArrayList<>();
        feedListObserver = new FeedListObserver();
        restApi = new RestApiImpl();
        if (getArguments() != null) {
            position = getArguments().getInt(ARG_PARAM1);
            mColumns = (TopTitleEntity.Columns) getArguments().getSerializable(ARG_PARAM2);
            if (null == mColumns)
                mColumns = new TopTitleEntity.Columns();
        }
        List<TopTitleEntity.SubColumns> mSubColumns = mColumns.subColumns;
        recommendHomeAdapter = new RecommendHomeAdapter(mContext, mDatas, mSubColumns);
        recommendHomeAdapter.setNotiListener(this);
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        mListView = findViewById(R.id.listview);

        ViewGroup.LayoutParams params = mListView.getLayoutParams();
        //layout = (HorizontalScrollView) findViewById(R.id.rl_modulename_refresh);
        params.height = mListView.getHeight(); //需要设置的listview的高度，你可以设置成一个定值，也可以设置成其他容器的高度，如果是其他容器高度，那么不要在oncreate中执行，需要做延时处理，否则高度为0
        params.height = 500;
        mListView.setLayoutParams(params);

        mListView.setAdapter(recommendHomeAdapter);
        mListView.setRecyclerListener(new AbsListView.RecyclerListener() {
            @Override
            public void onMovedToScrapHeap(View view) {
                int p = view.getId();
                if (p == recommendHomeAdapter.currentPlayingPosition) {
                    if (null != recommendHomeAdapter.youkuPlayerView && recommendHomeAdapter.youkuPlayerView.isPlaying())
                        recommendHomeAdapter.youkuPlayerView.pause();
                }
            }
        });
        mListView.setOnItemClickListener(this);
        mLoadingView = findViewById(R.id.loading_view);
        mLoadingView.setOnRetryListener(this);
        cacheData = (String) TsdSPUtils.get(mContext, TsdConstant.PREF_RECOMMENDED_HOME + position, "");
        renderFeedList(cacheData, true);
        isCanLoadData();
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = super.onCreateView(inflater, container, savedInstanceState);
        initRefreshLayout(view);
        return view;
    }

    @Override
    protected int setContentView() {
        return R.layout.tsd_fragment_recommend_home;
    }

    private BGARefreshLayout mRefreshLayout;

    private void initRefreshLayout(View view) {
        mRefreshLayout = (BGARefreshLayout) view.findViewById(R.id.rl_modulename_refresh);
        mRefreshLayout.setDelegate(this);
        BGANormalRefreshViewHolder refreshViewHolder = new BGANormalRefreshViewHolder(mContext, true);
        refreshViewHolder.setLoadingMoreText("努力推荐中");
        mRefreshLayout.setRefreshViewHolder(refreshViewHolder);
    }

    @Override
    protected void lazyLoad() {
        mRefreshLayout.beginRefreshing();
    }

    @Override
    public void onPause() {
        super.onPause();
        Firedata.pageViewEnd("recommend");
        if (null != recommendHomeAdapter && null != recommendHomeAdapter.youkuPlayerView) {
            recommendHomeAdapter.youkuPlayerView.onPause();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        Firedata.pageViewStart("recommend");
        if (null != recommendHomeAdapter && null != recommendHomeAdapter.youkuPlayerView) {
            recommendHomeAdapter.initPlayer(recommendHomeAdapter.youkuPlayerView);
            recommendHomeAdapter.youkuPlayerView.pause();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (null != recommendHomeAdapter && null != recommendHomeAdapter.youkuPlayerView) {
            recommendHomeAdapter.youkuPlayerView.onDestroy();
        }
    }

    public synchronized void renderFeedList(String response, boolean cache) {
        RecommendEntity recommendEntity;
        try {
            response = response.equals("") ? "error" : response;
            recommendEntity = GsonUtil.GsonToBean(response, RecommendEntity.class);
            TsdSPUtils.put(mContext, TsdConstant.PREF_RECOMMENDED_HOME + position, response);
            cacheData = response;
            if (PULL_TO_REFRESH) {
                mDatas.clear();
                pageCurrent = 0;
            }

            mDatas.addAll(recommendEntity.data);
            /*
            if (!cache) {
                AdManager.init(mDatas);
                final SparseArray<String> count = AdManager.getAdSlots();
                recommendHomeAdapter.loadAD(count);
            }
            */
            recommendHomeAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        //super.onSaveInstanceState(outState);
    }

    public void resetVideo() {
        if (null != recommendHomeAdapter) {
            new Thread(new Runnable() {
                @Override
                public void run() {
                    if (recommendHomeAdapter.resetDatas())
                        mainHandler.postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                recommendHomeAdapter.notifyDataSetChanged();
                            }
                        }, 2000);
                }
            }).start();
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        EventBus.getDefault().register(this);
    }

    @Override
    public void onStop() {
        super.onStop();
        EventBus.getDefault().unregister(this);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onMessageEvent(StopVideoEvent event) {
        resetVideo();
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        mContext = activity;
    }

    @Override
    public void onDetach() {
        super.onDetach();
        mContext = null;
    }

    private void setSelectedState(int secondDirectoryPosition) {
        List<TopTitleEntity.SubColumns> labelDatas = mColumns.subColumns;
        if (null == labelDatas) {
            return;
        }
        for (int i = 0; i < labelDatas.size(); i++) {
            TopTitleEntity.SubColumns labelData = labelDatas.get(i);
            labelData.isSelected = (i == secondDirectoryPosition);
        }
    }

    public void refresh(int secondDirectoryPosition) {
        this.secondDirectoryPosition = secondDirectoryPosition;
        setSelectedState(secondDirectoryPosition);
        PULL_TO_REFRESH = true;
        mSid = TimeUtil.getTimestamp();
        restApi.getFeedData(feedListObserver, 0, mSid, mColumns, secondDirectoryPosition);
    }

    @Override
    public void onRetry() {
        mLoadingView.notifyDataChanged(LoadingView.State.ing);
        FireDataManager.refresh("recommend");
        PULL_TO_REFRESH = true;
        mSid = TimeUtil.getTimestamp();
        restApi.getFeedData(feedListObserver, 0, mSid, mColumns, secondDirectoryPosition);
    }

    @Override
    public void onBGARefreshLayoutBeginRefreshing(BGARefreshLayout refreshLayout) {
        FireDataManager.refresh("recommend");
        PULL_TO_REFRESH = true;
        mSid = TimeUtil.getTimestamp();
        restApi.getFeedData(feedListObserver, 0, mSid, mColumns, secondDirectoryPosition);
    }

    private String getSid() {
        if (TextUtils.isEmpty(mSid))
            mSid = TimeUtil.getTimestamp();
        return mSid;
    }

    @Override
    public boolean onBGARefreshLayoutBeginLoadingMore(BGARefreshLayout refreshLayout) {
        FireDataManager.loadMore("recommend");
        pageCurrent = pageCurrent + TsdConstant.ONCE_HTTP_COUNT;
        PULL_TO_REFRESH = false;
        restApi.getFeedData(feedListObserver, pageCurrent, getSid(), mColumns, secondDirectoryPosition);
        return true;
    }

    @Override
    public void notifyData() {
        recommendHomeAdapter.notifyDataSetChanged();
    }

    private final class FeedListObserver extends StringCallback {

        @Override
        public void onError(Response<String> response) {
            super.onError(response);
            if (TextUtils.isEmpty(cacheData)) {
                mLoadingView.notifyDataChanged(LoadingView.State.error);
            }
            mRefreshLayout.endRefreshing();
            mRefreshLayout.endLoadingMore();
        }

        @Override
        public void onSuccess(Response<String> response) {
            String s = response.body();
            mLoadingView.notifyDataChanged(LoadingView.State.done);
            mRefreshLayout.endRefreshing();
            mRefreshLayout.endLoadingMore();
            renderFeedList(s, false);
        }
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        if (mDatas.get(position) instanceof RecommendEntity.Data) {
            RecommendEntity.Data data = mDatas.get(position);
            recommendHomeAdapter.notifyDataSetChanged();
            if (data.type.equals("seeHere")) {
                mDatas.remove(position);
                mListView.smoothScrollToPosition(0);
                mRefreshLayout.beginRefreshing();
            } else if (data.type.equals("feed")) {
                data.data.has_read = true;
                RecommendEntity.Data2 data2 = data.data;
                String iid = null == data2.iid ? "" : data2.iid;
                Object alg = null == data2.alg ? "" : data2.alg;
                Intent intent = new Intent();
                intent.setClass(mContext, TsdH5ReaderActivity.class);
                intent.putExtra(TsdConstant.EXTRA_IID, iid);
                EventBus.getDefault().post(new BuriedPointEvent(TsdConstant.ACTION_CLICK, iid, alg, null, null));
                startActivity(intent);
            }
        }
    }

}
