package ai.botbrain.ttcloud.sdk.fragment;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import ai.botbrain.ttcloud.sdk.util.LogUtil;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public abstract class LazyLoadFragment extends Fragment {
    private final String TAG = LazyLoadFragment.class.getSimpleName();

    protected boolean isInit = false;
    protected boolean isLoad = false;
    private View view;

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        view = inflater.inflate(setContentView(), container, false);
        view.setLayoutParams(new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        isInit = true;
        /**Initialize the time to load data**/
        //isCanLoadData();
        return view;
    }


    /**
     * Whether the view is already visible to the user, the system method.
     */
    @Override
    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        LogUtil.i(TAG, "isVisibleToUser" + isVisibleToUser);
        isCanLoadData();
    }

    /**
     * Whether data can be loaded.
     * The conditions under which data can be loaded:
     * 1.The view has been initialized
     * 2.The view is visible to the user
     */
    protected void isCanLoadData() {
        if (!isInit) {
            return;
        }

        if (getUserVisibleHint() && !isLoad) {
            lazyLoad();
            isLoad = true;
        } else {
            if (isLoad) {
                stopLoad();
            }
        }
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        isInit = false;
        isLoad = false;
    }

    protected abstract int setContentView();

    protected View getContentView() {
        return view;
    }

    protected <T extends View> T findViewById(int id) {
        return (T) getContentView().findViewById(id);
    }

    /**
     * When the view is initialized and visible to the user to really load the data.
     */
    protected abstract void lazyLoad();

    /**
     * You can override this method if the view is not already visible to the user and the data
     * has been loaded, and if you need to stop loading data when switching to another page
     */
    protected void stopLoad() {
    }

}
