package ai.botbrain.ttcloud.sdk.adapter;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.view.ViewGroup;

import java.util.List;

import ai.botbrain.ttcloud.sdk.fragment.GraphicFragment;
import ai.botbrain.ttcloud.sdk.fragment.RecommendHomeFragment;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class MyFragmentPagerAdapter extends FragmentStatePagerAdapter {

    private List<TopTitleEntity.Columns> mDatas;
    private TopTitleEntity.Data mData;
    public Fragment mCurrentFragment;

    public MyFragmentPagerAdapter(FragmentManager fm, TopTitleEntity.Data data) {
        super(fm);
        this.mData = data;
        mDatas = data.columns;
    }

    @Override
    public Fragment getItem(int position) {
        TopTitleEntity.Columns mColumns = mDatas.get(position);
        String type = mData.type;
        if (type.equals("video")) {
            return RecommendHomeFragment.newInstance(position, mColumns);
        }

        if (type.equals("article")) {
            return GraphicFragment.newInstance(position, mColumns);
        }
        return null;
    }

    @Override
    public int getCount() {
        return null == mDatas ? 0 : mDatas.size();
    }

    @Override
    public void setPrimaryItem(ViewGroup container, int position, Object object) {
        mCurrentFragment = (Fragment) object;
        if (null!=mCurrentFragment)
            mCallBack.getCurrentFragment(mCurrentFragment);
        super.setPrimaryItem(container, position, object);
    }

    @Override
    public CharSequence getPageTitle(int position) {
        TopTitleEntity.Columns columns = mDatas.get(position);
        String name = null == columns.name ? "" : columns.name;
        return name;
    }

    private MyFragmentPagerAdapterCallBack mCallBack;

    public void setCallBack(MyFragmentPagerAdapterCallBack callBack) {
        this.mCallBack = callBack;
        if (null!=mCurrentFragment)
            mCallBack.getCurrentFragment(mCurrentFragment);
    }

    public interface MyFragmentPagerAdapterCallBack {
        void getCurrentFragment(Fragment mCurrentFragment);
    }
}
