package ai.botbrain.ttcloud.api;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/6/29.
 */

public class TtcClient {

    private final boolean LOG;
    private final boolean DEBUG;
    private final boolean mShowResponse;

    private final boolean hideComment;

    public static class Builder {
        private boolean LOG;
        private boolean DEBUG;
        private boolean mShowResponse;

        private boolean hideComment;

        @SuppressWarnings("unused")
        public Builder setDebug() {
            DEBUG = true;
            return this;
        }

        /**
         * 显示日志
         *
         * @param showLog true or false
         * @return this
         */
        public Builder setLOG(boolean showLog) {
            LOG = showLog;
            return this;
        }

        /**
         * 隐藏评论功能
         * @return builder
         */
        @SuppressWarnings("unused")
        public Builder hideComment() {
            hideComment = true;
            return this;
        }

        /**
         * 网络数据请求调试
         *
         * @param b true or false
         * @return builder
         */
        public Builder setShowResponse(boolean b) {
            mShowResponse = b;
            return this;
        }

        public TtcClient build() {
            return new TtcClient(this);
        }
    }

    private TtcClient(Builder builder) {
        mShowResponse = builder.mShowResponse;
        LOG = builder.LOG;
        DEBUG = builder.DEBUG;
        hideComment = builder.hideComment;
    }

    boolean isShowResponse() {
        return mShowResponse;
    }

    boolean isShowLog() {
        return LOG;
    }

    boolean isDebug() {
        return DEBUG;
    }

    @SuppressWarnings("unused")
    boolean isHideComment() {
        return hideComment;
    }
}
