/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.util;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import java.util.List;

public class LocationUtils {
    private static final String TAG = "LocationUtils";
    private static volatile LocationUtils uniqueInstance;
    private LocationManager locationManager;
    private String locationProvider;
    private Location location;
    private Context mContext;
    LocationListener locationListener = new LocationListener(){

        public void onStatusChanged(String provider, int status, Bundle arg2) {
        }

        public void onProviderEnabled(String provider) {
        }

        public void onProviderDisabled(String provider) {
        }

        public void onLocationChanged(Location location) {
            location.getAccuracy();
            LocationUtils.this.setLocation(location);
        }
    };

    private LocationUtils(Context context) {
        this.mContext = context;
        this.getLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocationUtils getInstance(Context context) {
        if (uniqueInstance != null) return uniqueInstance;
        Class<LocationUtils> clazz = LocationUtils.class;
        synchronized (LocationUtils.class) {
            if (uniqueInstance != null) return uniqueInstance;
            uniqueInstance = new LocationUtils(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return uniqueInstance;
        }
    }

    private void getLocation() {
        this.locationManager = (LocationManager)this.mContext.getSystemService("location");
        List providers = this.locationManager.getProviders(true);
        if (providers.contains("network")) {
            Log.d((String)TAG, (String)"\u5982\u679c\u662f\u7f51\u7edc\u5b9a\u4f4d");
            this.locationProvider = "network";
        } else if (providers.contains("gps")) {
            Log.d((String)TAG, (String)"\u5982\u679c\u662fGPS\u5b9a\u4f4d");
            this.locationProvider = "gps";
        } else {
            Log.d((String)TAG, (String)"\u6ca1\u6709\u53ef\u7528\u7684\u4f4d\u7f6e\u63d0\u4f9b\u5668");
            return;
        }
        if (Build.VERSION.SDK_INT >= 23 && ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            return;
        }
        if (ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            return;
        }
        Location location = this.locationManager.getLastKnownLocation(this.locationProvider);
        if (location != null) {
            this.setLocation(location);
        }
        this.locationManager.requestLocationUpdates(this.locationProvider, 0L, 0.0f, this.locationListener);
    }

    private void setLocation(Location location) {
        this.location = location;
        String address = "\u7eac\u5ea6\uff1a" + location.getLatitude() + "\u7ecf\u5ea6\uff1a" + location.getLongitude();
        Log.d((String)TAG, (String)address);
    }

    public Location showLocation() {
        return this.location;
    }

    public void removeLocationUpdatesListener() {
        if (Build.VERSION.SDK_INT >= 23 && ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            return;
        }
        if (this.locationManager != null) {
            uniqueInstance = null;
            this.locationManager.removeUpdates(this.locationListener);
        }
    }
}

